/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.builders;

import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.FieldWriter;
import jdk.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import jdk.javadoc.internal.doclets.toolkit.builders.AbstractMemberBuilder;
import jdk.javadoc.internal.doclets.toolkit.builders.XMLNode;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public class FieldBuilder
extends AbstractMemberBuilder {
    private final TypeElement typeElement;
    private final VisibleMemberMap visibleMemberMap;
    private final FieldWriter writer;
    private final SortedSet<Element> fields;
    private VariableElement currentElement;

    private FieldBuilder(AbstractBuilder.Context context, TypeElement typeElement, FieldWriter writer) {
        super(context);
        this.typeElement = typeElement;
        this.writer = writer;
        this.visibleMemberMap = new VisibleMemberMap(typeElement, VisibleMemberMap.Kind.FIELDS, this.configuration);
        this.fields = this.visibleMemberMap.getLeafClassMembers();
    }

    public static FieldBuilder getInstance(AbstractBuilder.Context context, TypeElement typeElement, FieldWriter writer) {
        return new FieldBuilder(context, typeElement, writer);
    }

    @Override
    public String getName() {
        return "FieldDetails";
    }

    public SortedSet<Element> members(TypeElement typeElement) {
        return this.visibleMemberMap.getMembersFor(typeElement);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return !this.fields.isEmpty();
    }

    public void buildFieldDoc(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        if (!this.fields.isEmpty()) {
            Content fieldDetailsTree = this.writer.getFieldDetailsTreeHeader(this.typeElement, memberDetailsTree);
            for (Element element : this.fields) {
                this.currentElement = (VariableElement)element;
                Content fieldDocTree = this.writer.getFieldDocTreeHeader(this.currentElement, fieldDetailsTree);
                this.buildChildren(node, fieldDocTree);
                fieldDetailsTree.addContent(this.writer.getFieldDoc(fieldDocTree, this.currentElement.equals(this.fields.last())));
            }
            memberDetailsTree.addContent(this.writer.getFieldDetails(fieldDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content fieldDocTree) {
        fieldDocTree.addContent(this.writer.getSignature(this.currentElement));
    }

    public void buildDeprecationInfo(XMLNode node, Content fieldDocTree) {
        this.writer.addDeprecated(this.currentElement, fieldDocTree);
    }

    public void buildFieldComments(XMLNode node, Content fieldDocTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments(this.currentElement, fieldDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content fieldDocTree) {
        this.writer.addTags(this.currentElement, fieldDocTree);
    }

    public FieldWriter getWriter() {
        return this.writer;
    }
}

