/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell;

import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import jdk.jshell.Diag;
import jdk.jshell.GeneralWrap;
import jdk.jshell.MemoryFileManager;
import jdk.jshell.Unit;
import jdk.jshell.Util;
import jdk.jshell.Wrap;

final class OuterWrap
implements GeneralWrap {
    private final String packageName;
    private final String className;
    private final String userSource;
    private final GeneralWrap w;
    private final Wrap guts;

    public static OuterWrap wrapInClass(String packageName, String className, String imports, String userSource, Wrap guts) {
        Wrap.CompoundWrap kw = new Wrap.CompoundWrap(imports + "class " + className + " {\n", guts, "}\n");
        return new OuterWrap(packageName, className, userSource, kw, guts);
    }

    public static OuterWrap wrapImport(String userSource, Wrap guts) {
        return new OuterWrap("", "", userSource, guts, guts);
    }

    private OuterWrap(String packageName, String className, String userSource, GeneralWrap w, Wrap guts) {
        this.packageName = packageName;
        this.className = className;
        this.userSource = userSource;
        this.w = w;
        this.guts = guts;
    }

    @Override
    public final String wrapped() {
        return this.w.wrapped();
    }

    @Override
    public int snippetIndexToWrapIndex(int ui) {
        return this.w.snippetIndexToWrapIndex(ui);
    }

    @Override
    public int wrapIndexToSnippetIndex(int si) {
        return this.w.wrapIndexToSnippetIndex(si);
    }

    @Override
    public int firstSnippetIndex() {
        return this.w.firstSnippetIndex();
    }

    @Override
    public int lastSnippetIndex() {
        return this.w.lastSnippetIndex();
    }

    @Override
    public int snippetLineToWrapLine(int snline) {
        return this.w.snippetLineToWrapLine(snline);
    }

    @Override
    public int wrapLineToSnippetLine(int wline) {
        return this.w.wrapLineToSnippetLine(wline);
    }

    @Override
    public int firstSnippetLine() {
        return this.w.firstSnippetLine();
    }

    @Override
    public int lastSnippetLine() {
        return this.w.lastSnippetLine();
    }

    public String className() {
        return this.className;
    }

    public String classFullName() {
        return this.packageName + "." + this.className;
    }

    public String getUserSource() {
        return this.userSource;
    }

    Wrap guts() {
        return this.guts;
    }

    Diag wrapDiag(Diagnostic<? extends JavaFileObject> d) {
        return new WrappedDiagnostic(d);
    }

    class WrappedDiagnostic
    extends Diag {
        private final Diagnostic<? extends JavaFileObject> diag;

        WrappedDiagnostic(Diagnostic<? extends JavaFileObject> diag) {
            this.diag = diag;
        }

        @Override
        public boolean isError() {
            return this.diag.getKind() == Diagnostic.Kind.ERROR;
        }

        @Override
        public long getPosition() {
            return OuterWrap.this.wrapIndexToSnippetIndex(this.diag.getPosition());
        }

        @Override
        public long getStartPosition() {
            return OuterWrap.this.wrapIndexToSnippetIndex(this.diag.getStartPosition());
        }

        @Override
        public long getEndPosition() {
            return OuterWrap.this.wrapIndexToSnippetIndex(this.diag.getEndPosition());
        }

        @Override
        public String getCode() {
            return this.diag.getCode();
        }

        @Override
        public String getMessage(Locale locale) {
            return Util.expunge(this.diag.getMessage(locale));
        }

        @Override
        Unit unitOrNull() {
            MemoryFileManager.SourceMemoryJavaFileObject sfo;
            JavaFileObject fo = this.diag.getSource();
            if (fo instanceof MemoryFileManager.SourceMemoryJavaFileObject && (sfo = (MemoryFileManager.SourceMemoryJavaFileObject)fo).getOrigin() instanceof Unit) {
                return (Unit)sfo.getOrigin();
            }
            return null;
        }

        @Override
        boolean isResolutionError() {
            if (!super.isResolutionError()) {
                return false;
            }
            for (String line : this.diag.getMessage(Util.PARSED_LOCALE).split("\\r?\\n")) {
                if (!line.trim().startsWith("location:") || line.contains("$REPL")) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "WrappedDiagnostic(" + this.getMessage(null) + ":" + this.getPosition() + ")";
        }
    }
}

