/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.changedetail;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.common.data.UiCommandDetail;
import com.google.gerrit.common.errors.NoSuchEntityException;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.httpd.rpc.Handler;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.client.AccountPatchReview;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchLineCommentsUtil;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Revisions;
import com.google.gerrit.server.extensions.webui.UiActions;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListKey;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.util.Providers;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PatchSetDetailFactory
extends Handler<PatchSetDetail> {
    private static final Logger log = LoggerFactory.getLogger(PatchSetDetailFactory.class);
    private final PatchSetInfoFactory infoFactory;
    private final ReviewDb db;
    private final PatchListCache patchListCache;
    private final ChangeControl.Factory changeControlFactory;
    private final ChangesCollection changes;
    private final Revisions revisions;
    private final PatchLineCommentsUtil plcUtil;
    private Project.NameKey projectKey;
    private final PatchSet.Id psIdBase;
    private final PatchSet.Id psIdNew;
    private final AccountDiffPreference diffPrefs;
    private ObjectId oldId;
    private ObjectId newId;
    private PatchSetDetail detail;
    ChangeControl control;
    PatchSet patchSet;

    @Inject
    PatchSetDetailFactory(PatchSetInfoFactory psif, ReviewDb db, PatchListCache patchListCache, ChangeControl.Factory changeControlFactory, ChangesCollection changes, Revisions revisions, PatchLineCommentsUtil plcUtil, @Assisted(value="psIdBase") @Nullable PatchSet.Id psIdBase, @Assisted(value="psIdNew") PatchSet.Id psIdNew, @Assisted @Nullable AccountDiffPreference diffPrefs) {
        this.infoFactory = psif;
        this.db = db;
        this.patchListCache = patchListCache;
        this.changeControlFactory = changeControlFactory;
        this.changes = changes;
        this.revisions = revisions;
        this.plcUtil = plcUtil;
        this.psIdBase = psIdBase;
        this.psIdNew = psIdNew;
        this.diffPrefs = diffPrefs;
    }

    @Override
    public PatchSetDetail call() throws OrmException, NoSuchEntityException, PatchSetInfoNotAvailableException, NoSuchChangeException {
        PatchList list;
        if (this.control == null || this.patchSet == null) {
            this.control = this.changeControlFactory.validateFor(this.psIdNew.getParentKey());
            this.patchSet = this.db.patchSets().get(this.psIdNew);
            if (this.patchSet == null) {
                throw new NoSuchEntityException();
            }
        }
        this.projectKey = this.control.getProject().getNameKey();
        try {
            if (this.psIdBase != null) {
                this.oldId = this.toObjectId(this.psIdBase);
                this.newId = this.toObjectId(this.psIdNew);
                list = this.listFor(this.keyFor(this.diffPrefs.getIgnoreWhitespace()));
            } else {
                list = this.patchListCache.get(this.control.getChange(), this.patchSet);
            }
        }
        catch (PatchListNotAvailableException e) {
            throw new NoSuchEntityException();
        }
        List<Patch> patches = list.toPatchList(this.patchSet.getId());
        HashMap<Patch.Key, Patch> byKey = new HashMap<Patch.Key, Patch>();
        for (Patch p : patches) {
            byKey.put(p.getKey(), p);
        }
        ChangeNotes notes = this.control.getNotes();
        for (PatchLineComment c : this.plcUtil.publishedByPatchSet(this.db, notes, this.psIdNew)) {
            Patch p = (Patch)byKey.get(c.getKey().getParentKey());
            if (p == null) continue;
            p.setCommentCount(p.getCommentCount() + 1);
        }
        this.detail = new PatchSetDetail();
        this.detail.setPatchSet(this.patchSet);
        this.detail.setProject(this.projectKey);
        this.detail.setInfo(this.infoFactory.get(this.db, this.psIdNew));
        this.detail.setPatches(patches);
        CurrentUser user = this.control.getCurrentUser();
        if (user.isIdentifiedUser()) {
            Patch p;
            Account.Id me = ((IdentifiedUser)user).getAccountId();
            for (PatchLineComment c : this.db.patchComments().draftByPatchSetAuthor(this.psIdNew, me)) {
                p = (Patch)byKey.get(c.getKey().getParentKey());
                if (p == null) continue;
                p.setDraftCount(p.getDraftCount() + 1);
            }
            for (AccountPatchReview r : this.db.accountPatchReviews().byReviewer(me, this.psIdNew)) {
                p = (Patch)byKey.get(r.getKey().getPatchKey());
                if (p == null) continue;
                p.setReviewedByCurrentUser(true);
            }
        }
        this.detail.setCommands(Lists.newArrayList(Iterables.transform(UiActions.sorted(UiActions.plugins(UiActions.from(this.revisions, new RevisionResource(this.changes.parse(this.control), this.patchSet), Providers.of(user)))), new Function<UiAction.Description, UiCommandDetail>(){

            @Override
            public UiCommandDetail apply(UiAction.Description in) {
                UiCommandDetail r = new UiCommandDetail();
                r.method = in.getMethod();
                r.id = in.getId();
                r.label = in.getLabel();
                r.title = in.getTitle();
                r.enabled = in.isEnabled();
                return r;
            }
        })));
        return this.detail;
    }

    private ObjectId toObjectId(PatchSet.Id psId) throws OrmException, NoSuchEntityException {
        PatchSet ps = this.db.patchSets().get(psId);
        if (ps == null) {
            throw new NoSuchEntityException();
        }
        try {
            return ObjectId.fromString(ps.getRevision().get());
        }
        catch (IllegalArgumentException e) {
            log.error("Patch set " + psId + " has invalid revision");
            throw new NoSuchEntityException();
        }
    }

    private PatchListKey keyFor(AccountDiffPreference.Whitespace whitespace) {
        return new PatchListKey(this.projectKey, this.oldId, this.newId, whitespace);
    }

    private PatchList listFor(PatchListKey key) throws PatchListNotAvailableException {
        return this.patchListCache.get(key);
    }

    static interface Factory {
        public PatchSetDetailFactory create(@Assisted(value="psIdBase") @Nullable PatchSet.Id var1, @Assisted(value="psIdNew") PatchSet.Id var2, @Nullable AccountDiffPreference var3);
    }
}

