/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.CodedEnum;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.StringKey;

public final class Patch {
    public static final String COMMIT_MSG = "/COMMIT_MSG";
    protected Key key;
    protected char changeType;
    protected char patchType;
    protected int nbrComments;
    protected int nbrDrafts;
    protected int insertions;
    protected int deletions;
    protected String sourceFileName;
    private boolean reviewedByCurrentUser;

    protected Patch() {
    }

    public Patch(Key newId) {
        this.key = newId;
        this.setChangeType(ChangeType.MODIFIED);
        this.setPatchType(PatchType.UNIFIED);
    }

    public Key getKey() {
        return this.key;
    }

    public int getCommentCount() {
        return this.nbrComments;
    }

    public void setCommentCount(int n) {
        this.nbrComments = n;
    }

    public int getDraftCount() {
        return this.nbrDrafts;
    }

    public void setDraftCount(int n) {
        this.nbrDrafts = n;
    }

    public int getInsertions() {
        return this.insertions;
    }

    public void setInsertions(int n) {
        this.insertions = n;
    }

    public int getDeletions() {
        return this.deletions;
    }

    public void setDeletions(int n) {
        this.deletions = n;
    }

    public ChangeType getChangeType() {
        return ChangeType.forCode(this.changeType);
    }

    public void setChangeType(ChangeType type) {
        this.changeType = type.getCode();
    }

    public PatchType getPatchType() {
        return PatchType.forCode(this.patchType);
    }

    public void setPatchType(PatchType type) {
        this.patchType = type.getCode();
    }

    public String getFileName() {
        return this.key.fileName;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String n) {
        this.sourceFileName = n;
    }

    public boolean isReviewedByCurrentUser() {
        return this.reviewedByCurrentUser;
    }

    public void setReviewedByCurrentUser(boolean r) {
        this.reviewedByCurrentUser = r;
    }

    public String toString() {
        return "[Patch " + this.getKey().toString() + "]";
    }

    public static enum PatchType implements CodedEnum
    {
        UNIFIED('U'),
        BINARY('B');

        private final char code;

        private PatchType(char c) {
            this.code = c;
        }

        @Override
        public char getCode() {
            return this.code;
        }

        public static PatchType forCode(char c) {
            for (PatchType s : PatchType.values()) {
                if (s.code != c) continue;
                return s;
            }
            return null;
        }
    }

    public static enum ChangeType implements CodedEnum
    {
        ADDED('A'),
        MODIFIED('M'),
        DELETED('D'),
        RENAMED('R'),
        COPIED('C'),
        REWRITE('W');

        private final char code;

        private ChangeType(char c) {
            this.code = c;
        }

        @Override
        public char getCode() {
            return this.code;
        }

        public boolean matches(String s) {
            return s != null && s.length() == 1 && s.charAt(0) == this.code;
        }

        public static ChangeType forCode(char c) {
            for (ChangeType s : ChangeType.values()) {
                if (s.code != c) continue;
                return s;
            }
            return null;
        }
    }

    public static class Key
    extends StringKey<PatchSet.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1, name="--NONE--")
        protected PatchSet.Id patchSetId;
        @Column(id=2)
        protected String fileName;

        protected Key() {
            this.patchSetId = new PatchSet.Id();
        }

        public Key(PatchSet.Id ps, String name) {
            this.patchSetId = ps;
            this.fileName = name;
        }

        @Override
        public PatchSet.Id getParentKey() {
            return this.patchSetId;
        }

        @Override
        public String get() {
            return this.fileName;
        }

        @Override
        protected void set(String newValue) {
            this.fileName = newValue;
        }

        public static Key parse(String str) {
            Key r = new Key();
            r.fromString(str);
            return r;
        }

        public String getFileName() {
            return this.get();
        }
    }
}

