/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.archive.TarFormat;
import org.eclipse.jgit.archive.Tbz2Format;
import org.eclipse.jgit.archive.TgzFormat;
import org.eclipse.jgit.archive.TxzFormat;

public enum ArchiveFormat {
    TGZ("application/x-gzip", new TgzFormat()),
    TAR("application/x-tar", new TarFormat()),
    TBZ2("application/x-bzip2", new Tbz2Format()),
    TXZ("application/x-xz", new TxzFormat());

    private final ArchiveCommand.Format<?> format;
    private final String mimeType;

    private ArchiveFormat(String mimeType, ArchiveCommand.Format<?> format) {
        this.format = format;
        this.mimeType = mimeType;
        ArchiveCommand.registerFormat(this.name(), format);
    }

    public String getShortName() {
        return this.name().toLowerCase();
    }

    String getMimeType() {
        return this.mimeType;
    }

    String getDefaultSuffix() {
        return this.getSuffixes().iterator().next();
    }

    Iterable<String> getSuffixes() {
        return this.format.suffixes();
    }
}

