/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.server.change.MergeabilityChecksExecutor;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.WorkQueue;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Config;

public class MergeabilityChecksExecutorModule
extends AbstractModule {
    @Override
    protected void configure() {
    }

    @Provides
    @Singleton
    @MergeabilityChecksExecutor(value=MergeabilityChecksExecutor.Priority.BACKGROUND)
    public WorkQueue.Executor createMergeabilityChecksExecutor(@GerritServerConfig Config config, WorkQueue queues) {
        int poolSize = config.getInt("changeMerge", null, "threadPoolSize", 1);
        return queues.createQueue(poolSize, "MergeabilityChecks-Background");
    }

    @Provides
    @Singleton
    @MergeabilityChecksExecutor(value=MergeabilityChecksExecutor.Priority.INTERACTIVE)
    public WorkQueue.Executor createMergeabilityChecksExecutor(@GerritServerConfig Config config, WorkQueue queues, @MergeabilityChecksExecutor(value=MergeabilityChecksExecutor.Priority.BACKGROUND) WorkQueue.Executor backgroundExecutor) {
        int poolSize = config.getInt("changeMerge", null, "interactiveThreadPoolSize", 1);
        if (poolSize <= 0) {
            return backgroundExecutor;
        }
        return queues.createQueue(poolSize, "MergeabilityChecks-Interactive");
    }
}

