/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.extensions.common.Comment;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.CommentRange;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchLineCommentsUtil;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.change.EmailReviewComments;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.util.LabelVote;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostReview
implements RestModifyView<RevisionResource, ReviewInput> {
    private static final Logger log = LoggerFactory.getLogger(PostReview.class);
    private final Provider<ReviewDb> db;
    private final ChangesCollection changes;
    private final ChangeData.Factory changeDataFactory;
    private final ChangeUpdate.Factory updateFactory;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeMessagesUtil cmUtil;
    private final PatchLineCommentsUtil plcUtil;
    private final PatchListCache patchListCache;
    private final ChangeIndexer indexer;
    private final AccountsCollection accounts;
    private final EmailReviewComments.Factory email;
    @Deprecated
    private final ChangeHooks hooks;
    private Change change;
    private ChangeMessage message;
    private Timestamp timestamp;
    private List<PatchLineComment> comments = Lists.newArrayList();
    private List<String> labelDelta = Lists.newArrayList();
    private Map<String, Short> categories = Maps.newHashMap();

    @Inject
    PostReview(Provider<ReviewDb> db, ChangesCollection changes, ChangeData.Factory changeDataFactory, ChangeUpdate.Factory updateFactory, ApprovalsUtil approvalsUtil, ChangeMessagesUtil cmUtil, PatchLineCommentsUtil plcUtil, PatchListCache patchListCache, ChangeIndexer indexer, AccountsCollection accounts, EmailReviewComments.Factory email, ChangeHooks hooks) {
        this.db = db;
        this.changes = changes;
        this.changeDataFactory = changeDataFactory;
        this.updateFactory = updateFactory;
        this.plcUtil = plcUtil;
        this.patchListCache = patchListCache;
        this.approvalsUtil = approvalsUtil;
        this.cmUtil = cmUtil;
        this.indexer = indexer;
        this.accounts = accounts;
        this.email = email;
        this.hooks = hooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Output apply(RevisionResource revision, ReviewInput input) throws AuthException, BadRequestException, UnprocessableEntityException, OrmException, IOException {
        if (input.onBehalfOf != null) {
            revision = this.onBehalfOf(revision, input);
        }
        if (input.labels != null) {
            this.checkLabels(revision, input.strictLabels, input.labels);
        }
        if (input.comments != null) {
            this.checkComments(revision, input.comments);
        }
        if (input.notify == null) {
            log.warn("notify = null; assuming notify = NONE");
            input.notify = ReviewInput.NotifyHandling.NONE;
        }
        ChangeUpdate update = null;
        this.db.get().changes().beginTransaction(revision.getChange().getId());
        boolean dirty = false;
        try {
            this.change = this.db.get().changes().get(revision.getChange().getId());
            ChangeUtil.updated(this.change);
            this.timestamp = this.change.getLastUpdatedOn();
            update = this.updateFactory.create(revision.getControl(), this.timestamp);
            update.setPatchSetId(revision.getPatchSet().getId());
            dirty |= this.insertComments(revision, update, input.comments, input.drafts);
            dirty |= this.updateLabels(revision, update, input.labels);
            if (dirty |= this.insertMessage(revision, input.message, update)) {
                this.db.get().changes().update(Collections.singleton(this.change));
                this.db.get().commit();
            }
        }
        finally {
            this.db.get().rollback();
        }
        if (update != null) {
            update.commit();
        }
        CheckedFuture<Object, Object> indexWrite = dirty ? this.indexer.indexAsync(this.change.getId()) : Futures.immediateCheckedFuture(null);
        if (this.message != null && input.notify.compareTo(ReviewInput.NotifyHandling.NONE) > 0) {
            this.email.create(input.notify, this.change, revision.getPatchSet(), revision.getAccountId(), this.message, this.comments).sendAsync();
        }
        Output output = new Output();
        output.labels = input.labels;
        indexWrite.checkedGet();
        if (this.message != null) {
            this.fireCommentAddedHook(revision);
        }
        return output;
    }

    private RevisionResource onBehalfOf(RevisionResource rev, ReviewInput in) throws BadRequestException, AuthException, UnprocessableEntityException, OrmException {
        if (in.labels == null || in.labels.isEmpty()) {
            throw new AuthException(String.format("label required to post review on behalf of \"%s\"", in.onBehalfOf));
        }
        ChangeControl caller = rev.getControl();
        Iterator<Map.Entry<String, Short>> itr = in.labels.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, Short> ent = itr.next();
            LabelType type = caller.getLabelTypes().byLabel(ent.getKey());
            if (type == null && in.strictLabels) {
                throw new BadRequestException(String.format("label \"%s\" is not a configured label", ent.getKey()));
            }
            if (type == null) {
                itr.remove();
                continue;
            }
            PermissionRange r = caller.getRange(Permission.forLabelAs(type.getName()));
            if (r != null && !r.isEmpty() && r.contains(ent.getValue().shortValue())) continue;
            throw new AuthException(String.format("not permitted to modify label \"%s\" on behalf of \"%s\"", ent.getKey(), in.onBehalfOf));
        }
        if (in.labels.isEmpty()) {
            throw new AuthException(String.format("label required to post review on behalf of \"%s\"", in.onBehalfOf));
        }
        ChangeControl target = caller.forUser(this.accounts.parse(in.onBehalfOf));
        return new RevisionResource(this.changes.parse(target), rev.getPatchSet());
    }

    private void checkLabels(RevisionResource revision, boolean strict, Map<String, Short> labels) throws BadRequestException, AuthException {
        ChangeControl ctl = revision.getControl();
        Iterator<Map.Entry<String, Short>> itr = labels.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, Short> ent = itr.next();
            LabelType lt = revision.getControl().getLabelTypes().byLabel(ent.getKey());
            if (lt == null) {
                if (strict) {
                    throw new BadRequestException(String.format("label \"%s\" is not a configured label", ent.getKey()));
                }
                itr.remove();
                continue;
            }
            if (ent.getValue() == null || ent.getValue() == 0) continue;
            if (lt.getValue(ent.getValue()) == null) {
                if (strict) {
                    throw new BadRequestException(String.format("label \"%s\": %d is not a valid value", ent.getKey(), ent.getValue()));
                }
                itr.remove();
                continue;
            }
            String name = lt.getName();
            PermissionRange range = ctl.getRange(Permission.forLabel(name));
            if (range != null && range.contains(ent.getValue().shortValue())) continue;
            if (strict) {
                throw new AuthException(String.format("Applying label \"%s\": %d is restricted", ent.getKey(), ent.getValue()));
            }
            if (range == null || range.isEmpty()) {
                ent.setValue((short)0);
                continue;
            }
            ent.setValue((short)range.squash(ent.getValue().shortValue()));
        }
    }

    private void checkComments(RevisionResource revision, Map<String, List<ReviewInput.CommentInput>> in) throws BadRequestException, OrmException {
        Iterator<Map.Entry<String, List<ReviewInput.CommentInput>>> mapItr = in.entrySet().iterator();
        HashSet<String> filePaths = Sets.newHashSet(this.changeDataFactory.create(this.db.get(), revision.getChange()).filePaths(revision.getPatchSet()));
        while (mapItr.hasNext()) {
            Map.Entry<String, List<ReviewInput.CommentInput>> ent = mapItr.next();
            String path = ent.getKey();
            if (!filePaths.contains(path) && !"/COMMIT_MSG".equals(path)) {
                throw new BadRequestException(String.format("file %s not found in revision %s", path, revision.getChange().currentPatchSetId()));
            }
            List<ReviewInput.CommentInput> list = ent.getValue();
            if (list == null) {
                mapItr.remove();
                continue;
            }
            Iterator<ReviewInput.CommentInput> listItr = list.iterator();
            while (listItr.hasNext()) {
                ReviewInput.CommentInput c = listItr.next();
                if (c == null) {
                    listItr.remove();
                    continue;
                }
                if (c.line < 0) {
                    throw new BadRequestException(String.format("negative line number %d not allowed on %s", c.line, path));
                }
                c.message = Strings.nullToEmpty(c.message).trim();
                if (!c.message.isEmpty()) continue;
                listItr.remove();
            }
            if (!list.isEmpty()) continue;
            mapItr.remove();
        }
    }

    private boolean insertComments(RevisionResource rsrc, ChangeUpdate update, Map<String, List<ReviewInput.CommentInput>> in, ReviewInput.DraftHandling draftsHandling) throws OrmException, IOException {
        if (in == null) {
            in = Collections.emptyMap();
        }
        Map<Object, Object> drafts = Collections.emptyMap();
        if (!in.isEmpty() || draftsHandling != ReviewInput.DraftHandling.KEEP) {
            drafts = this.scanDraftComments(rsrc);
        }
        ArrayList<Object> del = Lists.newArrayList();
        ArrayList<PatchLineComment> ups = Lists.newArrayList();
        PatchList patchList = null;
        try {
            patchList = this.patchListCache.get(rsrc.getChange(), rsrc.getPatchSet());
        }
        catch (PatchListNotAvailableException e) {
            throw new OrmException("could not load PatchList for this patchset", e);
        }
        RevId patchSetCommit = new RevId(ObjectId.toString(patchList.getNewId()));
        RevId baseCommit = new RevId(ObjectId.toString(patchList.getOldId()));
        for (Map.Entry<String, List<ReviewInput.CommentInput>> entry : in.entrySet()) {
            String path = entry.getKey();
            for (ReviewInput.CommentInput c : entry.getValue()) {
                String parent = Url.decode(c.inReplyTo);
                PatchLineComment e = (PatchLineComment)drafts.remove(Url.decode(c.id));
                if (e == null) {
                    e = new PatchLineComment(new PatchLineComment.Key(new Patch.Key(rsrc.getPatchSet().getId(), path), ChangeUtil.messageUUID(this.db.get())), c.line, rsrc.getAccountId(), parent, this.timestamp);
                } else if (parent != null) {
                    e.setParentUuid(parent);
                }
                e.setStatus(PatchLineComment.Status.PUBLISHED);
                e.setWrittenOn(this.timestamp);
                e.setSide(c.side == Comment.Side.PARENT ? (short)0 : 1);
                e.setRevId(c.side == Comment.Side.PARENT ? baseCommit : patchSetCommit);
                e.setMessage(c.message);
                if (c.range != null) {
                    e.setRange(new CommentRange(c.range.startLine, c.range.startCharacter, c.range.endLine, c.range.endCharacter));
                    e.setLine(c.range.endLine);
                }
                ups.add(e);
            }
        }
        switch (Objects.firstNonNull(draftsHandling, ReviewInput.DraftHandling.DELETE)) {
            default: {
                break;
            }
            case DELETE: {
                del.addAll(drafts.values());
                break;
            }
            case PUBLISH: {
                for (PatchLineComment patchLineComment : drafts.values()) {
                    patchLineComment.setStatus(PatchLineComment.Status.PUBLISHED);
                    patchLineComment.setWrittenOn(this.timestamp);
                    patchLineComment.setRevId(patchLineComment.getSide() == 0 ? baseCommit : patchSetCommit);
                    ups.add(patchLineComment);
                }
            }
        }
        this.db.get().patchComments().delete(del);
        this.plcUtil.addPublishedComments(this.db.get(), update, ups);
        this.comments.addAll(ups);
        return !del.isEmpty() || !ups.isEmpty();
    }

    private Map<String, PatchLineComment> scanDraftComments(RevisionResource rsrc) throws OrmException {
        HashMap<String, PatchLineComment> drafts = Maps.newHashMap();
        for (PatchLineComment c : this.db.get().patchComments().draftByPatchSetAuthor(rsrc.getPatchSet().getId(), rsrc.getAccountId())) {
            drafts.put(c.getKey().get(), c);
        }
        return drafts;
    }

    private boolean updateLabels(RevisionResource rsrc, ChangeUpdate update, Map<String, Short> labels) throws OrmException {
        if (labels == null) {
            labels = Collections.emptyMap();
        }
        ArrayList<PatchSetApproval> del = Lists.newArrayList();
        ArrayList<PatchSetApproval> ups = Lists.newArrayList();
        Map<String, PatchSetApproval> current = this.scanLabels(rsrc, del);
        LabelTypes labelTypes = rsrc.getControl().getLabelTypes();
        for (Map.Entry<String, Short> ent : labels.entrySet()) {
            String name = ent.getKey();
            LabelType lt = Preconditions.checkNotNull(labelTypes.byLabel(name), name);
            if (this.change.getStatus().isClosed()) continue;
            PatchSetApproval c = current.remove(lt.getName());
            String normName = lt.getName();
            if (ent.getValue() == null || ent.getValue() == 0) {
                if (c == null) continue;
                if (c.getValue() != 0) {
                    this.addLabelDelta(normName, (short)0);
                }
                del.add(c);
                update.putApproval(ent.getKey(), (short)0);
                continue;
            }
            if (c != null && c.getValue() != ent.getValue().shortValue()) {
                c.setValue(ent.getValue());
                c.setGranted(this.timestamp);
                ups.add(c);
                this.addLabelDelta(normName, c.getValue());
                this.categories.put(normName, c.getValue());
                update.putApproval(ent.getKey(), ent.getValue());
                continue;
            }
            if (c != null && c.getValue() == ent.getValue().shortValue()) {
                current.put(normName, c);
                continue;
            }
            if (c != null) continue;
            c = new PatchSetApproval(new PatchSetApproval.Key(rsrc.getPatchSet().getId(), rsrc.getAccountId(), lt.getLabelId()), ent.getValue(), TimeUtil.nowTs());
            c.setGranted(this.timestamp);
            ups.add(c);
            this.addLabelDelta(normName, c.getValue());
            this.categories.put(normName, c.getValue());
            update.putApproval(ent.getKey(), ent.getValue());
        }
        this.forceCallerAsReviewer(rsrc, current, ups, del);
        this.db.get().patchSetApprovals().delete(del);
        this.db.get().patchSetApprovals().upsert(ups);
        return !del.isEmpty() || !ups.isEmpty();
    }

    private void forceCallerAsReviewer(RevisionResource rsrc, Map<String, PatchSetApproval> current, List<PatchSetApproval> ups, List<PatchSetApproval> del) {
        if (current.isEmpty() && ups.isEmpty()) {
            if (del.isEmpty()) {
                PatchSetApproval c = new PatchSetApproval(new PatchSetApproval.Key(rsrc.getPatchSet().getId(), rsrc.getAccountId(), rsrc.getControl().getLabelTypes().getLabelTypes().get(0).getLabelId()), 0, TimeUtil.nowTs());
                c.setGranted(this.timestamp);
                ups.add(c);
            } else {
                Iterator<PatchSetApproval> i = del.iterator();
                PatchSetApproval c = i.next();
                c.setValue((short)0);
                c.setGranted(this.timestamp);
                i.remove();
                ups.add(c);
            }
        }
    }

    private Map<String, PatchSetApproval> scanLabels(RevisionResource rsrc, List<PatchSetApproval> del) throws OrmException {
        LabelTypes labelTypes = rsrc.getControl().getLabelTypes();
        HashMap<String, PatchSetApproval> current = Maps.newHashMap();
        for (PatchSetApproval a : this.approvalsUtil.byPatchSetUser(this.db.get(), rsrc.getControl(), rsrc.getPatchSet().getId(), rsrc.getAccountId())) {
            if (a.isSubmit()) continue;
            LabelType lt = labelTypes.byLabel(a.getLabelId());
            if (lt != null) {
                current.put(lt.getName(), a);
                continue;
            }
            del.add(a);
        }
        return current;
    }

    private void addLabelDelta(String name, short value) {
        this.labelDelta.add(new LabelVote(name, value).format());
    }

    private boolean insertMessage(RevisionResource rsrc, String msg, ChangeUpdate update) throws OrmException {
        msg = Strings.nullToEmpty(msg).trim();
        StringBuilder buf = new StringBuilder();
        for (String d : this.labelDelta) {
            buf.append(" ").append(d);
        }
        if (this.comments.size() == 1) {
            buf.append("\n\n(1 comment)");
        } else if (this.comments.size() > 1) {
            buf.append(String.format("\n\n(%d comments)", this.comments.size()));
        }
        if (!msg.isEmpty()) {
            buf.append("\n\n").append(msg);
        }
        if (buf.length() == 0) {
            return false;
        }
        this.message = new ChangeMessage(new ChangeMessage.Key(this.change.getId(), ChangeUtil.messageUUID(this.db.get())), rsrc.getAccountId(), this.timestamp, rsrc.getPatchSet().getId());
        this.message.setMessage(String.format("Patch Set %d:%s", rsrc.getPatchSet().getPatchSetId(), buf.toString()));
        this.cmUtil.addChangeMessage(this.db.get(), update, this.message);
        return true;
    }

    @Deprecated
    private void fireCommentAddedHook(RevisionResource rsrc) {
        IdentifiedUser user = (IdentifiedUser)rsrc.getControl().getCurrentUser();
        try {
            this.hooks.doCommentAddedHook(this.change, user.getAccount(), rsrc.getPatchSet(), this.message.getMessage(), this.categories, this.db.get());
        }
        catch (OrmException e) {
            log.warn("ChangeHook.doCommentAddedHook delivery failed", e);
        }
    }

    static class Output {
        Map<String, Short> labels;

        Output() {
        }
    }
}

