/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountProjectWatch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.mail.EmailArguments;
import com.google.gerrit.server.mail.RecipientType;
import com.google.gerrit.server.mail.ReplyToChangeSender;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReplacePatchSetSender
extends ReplyToChangeSender {
    private final Set<Account.Id> reviewers = new HashSet<Account.Id>();
    private final Set<Account.Id> extraCC = new HashSet<Account.Id>();

    @Inject
    public ReplacePatchSetSender(EmailArguments ea, @Assisted Change c) {
        super(ea, c, "newpatchset");
    }

    public void addReviewers(Collection<Account.Id> cc) {
        this.reviewers.addAll(cc);
    }

    public void addExtraCC(Collection<Account.Id> cc) {
        this.extraCC.addAll(cc);
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        if (this.fromId != null) {
            this.reviewers.remove(this.fromId);
        }
        this.add(RecipientType.TO, this.reviewers);
        this.add(RecipientType.CC, this.extraCC);
        this.rcptToAuthors(RecipientType.CC);
        this.bccStarredBy();
        this.includeWatchers(AccountProjectWatch.NotifyType.NEW_PATCHSETS);
    }

    @Override
    protected void formatChange() throws EmailException {
        this.appendText(this.velocifyFile("ReplacePatchSet.vm"));
    }

    public List<String> getReviewerNames() {
        if (this.reviewers.isEmpty()) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Account.Id id : this.reviewers) {
            names.add(this.getNameFor(id));
        }
        return names;
    }

    public static interface Factory {
        public ReplacePatchSetSender create(Change var1);
    }
}

