/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.ChangeIndex;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.LegacyChangeIdPredicate;
import com.google.gwtorm.server.OrmException;

class CommentPredicate
extends IndexPredicate<ChangeData> {
    private final ChangeQueryBuilder.Arguments args;
    private final ChangeIndex index;

    CommentPredicate(ChangeQueryBuilder.Arguments args, ChangeIndex index, String value) {
        super(ChangeField.COMMENT, value);
        this.args = args;
        this.index = index;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        try {
            for (ChangeData cData : this.index.getSource(Predicate.and(new LegacyChangeIdPredicate(this.args, object.getId()), this), 0, 1).read()) {
                if (!cData.getId().equals(object.getId())) continue;
                return true;
            }
        }
        catch (QueryParseException e) {
            throw new OrmException(e);
        }
        return false;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

