/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.Version;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.extensions.common.InheritableBoolean;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class AllProjectsCreator {
    private final GitRepositoryManager mgr;
    private final AllProjectsName allProjectsName;
    private final PersonIdent serverUser;
    private GroupReference admin;
    private GroupReference batch;
    private GroupReference anonymous;
    private GroupReference registered;
    private GroupReference owners;

    @Inject
    AllProjectsCreator(GitRepositoryManager mgr, AllProjectsName allProjectsName, @GerritPersonIdent PersonIdent serverUser) {
        this.mgr = mgr;
        this.allProjectsName = allProjectsName;
        this.serverUser = serverUser;
        this.anonymous = SystemGroupBackend.getGroup(SystemGroupBackend.ANONYMOUS_USERS);
        this.registered = SystemGroupBackend.getGroup(SystemGroupBackend.REGISTERED_USERS);
        this.owners = SystemGroupBackend.getGroup(SystemGroupBackend.PROJECT_OWNERS);
    }

    public AllProjectsCreator setAdministrators(GroupReference admin) {
        this.admin = admin;
        return this;
    }

    public AllProjectsCreator setBatchUsers(GroupReference batch) {
        this.batch = batch;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws IOException, ConfigInvalidException {
        try (Repository git = null;){
            git = this.mgr.openRepository(this.allProjectsName);
            this.initAllProjects(git);
        }
    }

    private void initAllProjects(Repository git) throws IOException, ConfigInvalidException {
        MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allProjectsName, git);
        md.getCommitBuilder().setAuthor(this.serverUser);
        md.getCommitBuilder().setCommitter(this.serverUser);
        md.setMessage("Initialized Gerrit Code Review " + Version.getVersion());
        ProjectConfig config = ProjectConfig.read(md);
        Project p = config.getProject();
        p.setDescription("Access inherited by all other projects.");
        p.setRequireChangeID(InheritableBoolean.TRUE);
        p.setUseContentMerge(InheritableBoolean.TRUE);
        p.setUseContributorAgreements(InheritableBoolean.FALSE);
        p.setUseSignedOffBy(InheritableBoolean.FALSE);
        AccessSection cap = config.getAccessSection("GLOBAL_CAPABILITIES", true);
        AccessSection all = config.getAccessSection("refs/*", true);
        AccessSection heads = config.getAccessSection("refs/heads/*", true);
        AccessSection tags = config.getAccessSection("refs/tags/*", true);
        AccessSection meta = config.getAccessSection("refs/meta/config", true);
        AccessSection magic = config.getAccessSection("refs/for/refs/*", true);
        this.grant(config, cap, "administrateServer", this.admin);
        this.grant(config, all, "read", this.admin, this.anonymous);
        if (this.batch != null) {
            Permission priority = cap.getPermission("priority", true);
            PermissionRule r = this.rule(config, this.batch);
            r.setAction(PermissionRule.Action.BATCH);
            priority.add(r);
            Permission stream = cap.getPermission("streamEvents", true);
            stream.add(this.rule(config, this.batch));
        }
        LabelType cr = AllProjectsCreator.initCodeReviewLabel(config);
        this.grant(config, heads, cr, -1, 1, this.registered);
        this.grant(config, heads, cr, -2, 2, this.admin, this.owners);
        this.grant(config, heads, "create", this.admin, this.owners);
        this.grant(config, heads, "push", this.admin, this.owners);
        this.grant(config, heads, "submit", this.admin, this.owners);
        this.grant(config, heads, "forgeAuthor", this.registered);
        this.grant(config, heads, "forgeCommitter", this.admin, this.owners);
        this.grant(config, heads, "editTopicName", true, this.admin, this.owners);
        this.grant(config, tags, "pushTag", this.admin, this.owners);
        this.grant(config, tags, "pushSignedTag", this.admin, this.owners);
        this.grant(config, magic, "push", this.registered);
        this.grant(config, magic, "pushMerge", this.registered);
        meta.getPermission("read", true).setExclusiveGroup(true);
        this.grant(config, meta, "read", this.admin, this.owners);
        this.grant(config, meta, cr, -2, 2, this.admin, this.owners);
        this.grant(config, meta, "push", this.admin, this.owners);
        this.grant(config, meta, "submit", this.admin, this.owners);
        config.commitToNewRef(md, "refs/meta/config");
    }

    private void grant(ProjectConfig config, AccessSection section, String permission, GroupReference ... groupList) {
        this.grant(config, section, permission, false, groupList);
    }

    private void grant(ProjectConfig config, AccessSection section, String permission, boolean force, GroupReference ... groupList) {
        Permission p = section.getPermission(permission, true);
        for (GroupReference group : groupList) {
            if (group == null) continue;
            PermissionRule r = this.rule(config, group);
            r.setForce(force);
            p.add(r);
        }
    }

    private void grant(ProjectConfig config, AccessSection section, LabelType type, int min, int max, GroupReference ... groupList) {
        String name = "label-" + type.getName();
        Permission p = section.getPermission(name, true);
        for (GroupReference group : groupList) {
            if (group == null) continue;
            PermissionRule r = this.rule(config, group);
            r.setRange(min, max);
            p.add(r);
        }
    }

    private PermissionRule rule(ProjectConfig config, GroupReference group) {
        return new PermissionRule(config.resolve(group));
    }

    public static LabelType initCodeReviewLabel(ProjectConfig c) {
        LabelType type = new LabelType("Code-Review", ImmutableList.of(new LabelValue(2, "Looks good to me, approved"), new LabelValue(1, "Looks good to me, but someone else must approve"), new LabelValue(0, "No score"), new LabelValue(-1, "I would prefer this is not merged as is"), new LabelValue(-2, "This shall not be merged")));
        type.setCopyMinScore(true);
        c.getLabelSections().put(type.getName(), type);
        return type;
    }
}

