/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.client.CurrentSchemaVersion;
import com.google.gerrit.reviewdb.client.SystemConfig;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.schema.Current;
import com.google.gerrit.server.schema.SchemaCreator;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import org.eclipse.jgit.errors.ConfigInvalidException;

public class SchemaUpdater {
    private final SchemaFactory<ReviewDb> schema;
    private final SitePaths site;
    private final SchemaCreator creator;
    private final Provider<SchemaVersion> updater;

    @Inject
    SchemaUpdater(SchemaFactory<ReviewDb> schema, SitePaths site, SchemaCreator creator, @Current Provider<SchemaVersion> update) {
        this.schema = schema;
        this.site = site;
        this.creator = creator;
        this.updater = update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(UpdateUI ui) throws OrmException {
        block9: {
            try (ReviewDb db = this.schema.open();){
                SchemaVersion u = this.updater.get();
                CurrentSchemaVersion version = this.getSchemaVersion(db);
                if (version == null) {
                    try {
                        this.creator.create(db);
                        break block9;
                    }
                    catch (IOException e) {
                        throw new OrmException("Cannot initialize schema", e);
                    }
                    catch (ConfigInvalidException e) {
                        throw new OrmException("Cannot initialize schema", e);
                    }
                }
                try {
                    u.check(ui, version, db);
                }
                catch (SQLException e) {
                    throw new OrmException("Cannot upgrade schema", e);
                }
                this.updateSystemConfig(db);
            }
        }
    }

    private CurrentSchemaVersion getSchemaVersion(ReviewDb db) {
        try {
            return db.schemaVersion().get(new CurrentSchemaVersion.Key());
        }
        catch (OrmException e) {
            return null;
        }
    }

    private void updateSystemConfig(ReviewDb db) throws OrmException {
        SystemConfig sc = db.systemConfig().get(new SystemConfig.Key());
        if (sc == null) {
            throw new OrmException("No record in system_config table");
        }
        try {
            sc.sitePath = this.site.site_path.getCanonicalPath();
        }
        catch (IOException e) {
            sc.sitePath = this.site.site_path.getAbsolutePath();
        }
        db.systemConfig().update(Collections.singleton(sc));
    }
}

