/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.extensions.common.InheritableBoolean;
import com.google.gerrit.extensions.common.SubmitType;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.SystemConfig;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.GroupUUID;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_52;
import com.google.gerrit.server.schema.Schema_77;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

class Schema_53
extends SchemaVersion {
    private final GitRepositoryManager mgr;
    private final PersonIdent serverUser;
    private SystemConfig systemConfig;
    private Map<AccountGroup.Id, GroupReference> groupMap;
    private Schema_77.LegacyLabelTypes labelTypes;
    private GroupReference projectOwners;
    private Map<Project.NameKey, Project.NameKey> parentsByProject;
    private Map<Project.NameKey, List<OldRefRight>> rightsByProject;
    private final String OLD_SUBMIT = "SUBM";
    private final String OLD_READ = "READ";
    private final String OLD_OWN = "OWN";
    private final String OLD_PUSH_TAG = "pTAG";
    private final String OLD_PUSH_HEAD = "pHD";
    private final String OLD_FORGE_IDENTITY = "FORG";

    @Inject
    Schema_53(Provider<Schema_52> prior, GitRepositoryManager mgr, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.mgr = mgr;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        this.systemConfig = db.systemConfig().get(new SystemConfig.Key());
        this.labelTypes = Schema_77.getLegacyTypes(db);
        this.assignGroupUUIDs(db);
        this.readOldRefRights(db);
        this.readProjectParents(db);
        this.exportProjectConfig(db);
        this.deleteActionCategories(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteActionCategories(ReviewDb db) throws OrmException {
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();){
            stmt.executeUpdate("DELETE FROM approval_categories WHERE position < 0");
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    private void assignGroupUUIDs(ReviewDb db) throws OrmException {
        this.groupMap = new HashMap<AccountGroup.Id, GroupReference>();
        List<AccountGroup> groups = db.accountGroups().all().toList();
        for (AccountGroup g : groups) {
            if (g.getId().equals(this.systemConfig.ownerGroupId)) {
                g.setGroupUUID(SystemGroupBackend.PROJECT_OWNERS);
                this.projectOwners = GroupReference.forGroup(g);
            } else if (g.getId().equals(this.systemConfig.anonymousGroupId)) {
                g.setGroupUUID(SystemGroupBackend.ANONYMOUS_USERS);
            } else if (g.getId().equals(this.systemConfig.registeredGroupId)) {
                g.setGroupUUID(SystemGroupBackend.REGISTERED_USERS);
            } else {
                g.setGroupUUID(GroupUUID.make(g.getName(), this.serverUser));
            }
            this.groupMap.put(g.getId(), GroupReference.forGroup(g));
        }
        db.accountGroups().update(groups);
        this.systemConfig.adminGroupUUID = this.toUUID(this.systemConfig.adminGroupId);
        this.systemConfig.batchUsersGroupUUID = this.toUUID(this.systemConfig.batchUsersGroupId);
        db.systemConfig().update(Collections.singleton(this.systemConfig));
    }

    private AccountGroup.UUID toUUID(AccountGroup.Id id) {
        return this.groupMap.get(id).getUUID();
    }

    private void exportProjectConfig(ReviewDb db) throws OrmException, SQLException {
        Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM projects ORDER BY name");
        while (rs.next()) {
            Repository git;
            String name = rs.getString("name");
            Project.NameKey nameKey = new Project.NameKey(name);
            try {
                git = this.mgr.openRepository(nameKey);
            }
            catch (RepositoryNotFoundException notFound) {
                try {
                    git = this.mgr.createRepository(nameKey);
                }
                catch (IOException err) {
                    throw new OrmException("Cannot create repository " + name, err);
                }
            }
            catch (IOException e) {
                throw new OrmException(e);
            }
            try {
                MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, nameKey, git);
                md.getCommitBuilder().setAuthor(this.serverUser);
                md.getCommitBuilder().setCommitter(this.serverUser);
                ProjectConfig config = ProjectConfig.read(md);
                this.loadProject(rs, config.getProject());
                config.getAccessSections().clear();
                this.convertRights(config);
                if (config.getProject().getNameKey().equals(this.systemConfig.wildProjectName)) {
                    AccessSection meta = config.getAccessSection("refs/meta/config", true);
                    Permission read = meta.getPermission("read", true);
                    read.getRule(config.resolve(this.projectOwners), true);
                }
                md.setMessage("Import project configuration from SQL\n");
                config.commit(md);
            }
            catch (ConfigInvalidException err) {
                throw new OrmException("Cannot read project " + name, err);
            }
            catch (IOException err) {
                throw new OrmException("Cannot export project " + name, err);
            }
            finally {
                git.close();
            }
        }
        rs.close();
        stmt.close();
    }

    private void loadProject(ResultSet rs, Project project) throws SQLException, OrmException {
        project.setDescription(rs.getString("description"));
        project.setUseContributorAgreements(Schema_53.asInheritableBoolean(rs, "use_contributor_agreements"));
        switch (rs.getString("submit_type").charAt(0)) {
            case 'F': {
                project.setSubmitType(SubmitType.FAST_FORWARD_ONLY);
                break;
            }
            case 'M': {
                project.setSubmitType(SubmitType.MERGE_IF_NECESSARY);
                break;
            }
            case 'A': {
                project.setSubmitType(SubmitType.MERGE_ALWAYS);
                break;
            }
            case 'C': {
                project.setSubmitType(SubmitType.CHERRY_PICK);
                break;
            }
            default: {
                throw new OrmException("Unsupported submit_type=" + rs.getString("submit_type") + " on project " + project.getName());
            }
        }
        project.setUseSignedOffBy(Schema_53.asInheritableBoolean(rs, "use_signed_off_by"));
        project.setRequireChangeID(Schema_53.asInheritableBoolean(rs, "require_change_id"));
        project.setUseContentMerge(Schema_53.asInheritableBoolean(rs, "use_content_merge"));
        project.setParentName(rs.getString("parent_name"));
    }

    private static InheritableBoolean asInheritableBoolean(ResultSet rs, String col) throws SQLException {
        return "Y".equals(rs.getString(col)) ? InheritableBoolean.TRUE : InheritableBoolean.INHERIT;
    }

    private void readOldRefRights(ReviewDb db) throws SQLException {
        this.rightsByProject = new HashMap<Project.NameKey, List<OldRefRight>>();
        Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM ref_rights");
        while (rs.next()) {
            OldRefRight right = new OldRefRight(rs);
            if (right.group == null || right.category == null) continue;
            List<OldRefRight> list = this.rightsByProject.get(right.project);
            if (list == null) {
                list = new ArrayList<OldRefRight>();
                this.rightsByProject.put(right.project, list);
            }
            list.add(right);
        }
        rs.close();
        stmt.close();
    }

    private void readProjectParents(ReviewDb db) throws SQLException {
        this.parentsByProject = new HashMap<Project.NameKey, Project.NameKey>();
        Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM projects");
        while (rs.next()) {
            String name = rs.getString("name");
            String parent_name = rs.getString("parent_name");
            if (parent_name == null) {
                parent_name = this.systemConfig.wildProjectName.get();
            }
            this.parentsByProject.put(new Project.NameKey(name), new Project.NameKey(parent_name));
        }
        rs.close();
        stmt.close();
    }

    private void convertRights(ProjectConfig config) {
        List<OldRefRight> myRights = this.rightsByProject.get(config.getProject().getNameKey());
        if (myRights == null) {
            return;
        }
        for (OldRefRight old : myRights) {
            Schema_77.LegacyLabelType type;
            PermissionRule push;
            AccessSection section = config.getAccessSection(old.ref_pattern, true);
            GroupReference group = config.resolve(old.group);
            if ("SUBM".equals(old.category)) {
                PermissionRule submit = Schema_53.rule(group);
                if (old.max_value <= 0) {
                    submit.setDeny();
                }
                Schema_53.add(section, "submit", old.exclusive, submit);
                continue;
            }
            if ("READ".equals(old.category)) {
                if (old.exclusive) {
                    section.getPermission("read", true).setExclusiveGroup(true);
                    Schema_53.newChangePermission(config, old.ref_pattern).setExclusiveGroup(true);
                }
                PermissionRule read = Schema_53.rule(group);
                if (old.max_value <= 0) {
                    read.setDeny();
                }
                Schema_53.add(section, "read", old.exclusive, read);
                if (3 <= old.max_value) {
                    Schema_53.newMergePermission(config, old.ref_pattern).add(Schema_53.rule(group));
                } else if (3 <= this.inheritedMax(config, old)) {
                    Schema_53.newMergePermission(config, old.ref_pattern).add(Schema_53.deny(group));
                }
                if (2 <= old.max_value) {
                    Schema_53.newChangePermission(config, old.ref_pattern).add(Schema_53.rule(group));
                    continue;
                }
                if (2 > this.inheritedMax(config, old)) continue;
                Schema_53.newChangePermission(config, old.ref_pattern).add(Schema_53.deny(group));
                continue;
            }
            if ("OWN".equals(old.category)) {
                Schema_53.add(section, "owner", false, Schema_53.rule(group));
                continue;
            }
            if ("pTAG".equals(old.category)) {
                push = Schema_53.rule(group);
                if (old.max_value <= 0) {
                    push.setDeny();
                }
                Schema_53.add(section, "pushTag", old.exclusive, push);
                continue;
            }
            if ("pHD".equals(old.category)) {
                if (old.exclusive) {
                    section.getPermission("push", true).setExclusiveGroup(true);
                    section.getPermission("create", true).setExclusiveGroup(true);
                }
                push = Schema_53.rule(group);
                if (old.max_value <= 0) {
                    push.setDeny();
                }
                push.setForce(3 <= old.max_value);
                Schema_53.add(section, "push", old.exclusive, push);
                if (2 <= old.max_value) {
                    Schema_53.add(section, "create", old.exclusive, Schema_53.rule(group));
                    continue;
                }
                if (2 > this.inheritedMax(config, old)) continue;
                Schema_53.add(section, "create", old.exclusive, Schema_53.deny(group));
                continue;
            }
            if ("FORG".equals(old.category)) {
                if (old.exclusive) {
                    section.getPermission("forgeAuthor", true).setExclusiveGroup(true);
                    section.getPermission("forgeCommitter", true).setExclusiveGroup(true);
                    section.getPermission("forgeServerAsCommitter", true).setExclusiveGroup(true);
                }
                if (1 <= old.max_value) {
                    Schema_53.add(section, "forgeAuthor", old.exclusive, Schema_53.rule(group));
                }
                if (2 <= old.max_value) {
                    Schema_53.add(section, "forgeCommitter", old.exclusive, Schema_53.rule(group));
                } else if (2 <= this.inheritedMax(config, old)) {
                    Schema_53.add(section, "forgeCommitter", old.exclusive, Schema_53.deny(group));
                }
                if (3 <= old.max_value) {
                    Schema_53.add(section, "forgeServerAsCommitter", old.exclusive, Schema_53.rule(group));
                    continue;
                }
                if (3 > this.inheritedMax(config, old)) continue;
                Schema_53.add(section, "forgeServerAsCommitter", old.exclusive, Schema_53.deny(group));
                continue;
            }
            PermissionRule rule = Schema_53.rule(group);
            rule.setRange(old.min_value, old.max_value);
            if (old.min_value == 0 && old.max_value == 0) {
                rule.setDeny();
            }
            String name = (type = this.labelTypes.byLabel(new PatchSetApproval.LabelId(old.category))) != null ? type.getName() : old.category;
            Schema_53.add(section, "label-" + name, old.exclusive, rule);
        }
    }

    private static Permission newChangePermission(ProjectConfig config, String name) {
        name = name.startsWith("^") ? "^refs/for/" + name.substring("^".length()) : "refs/for/" + name;
        return config.getAccessSection(name, true).getPermission("push", true);
    }

    private static Permission newMergePermission(ProjectConfig config, String name) {
        name = name.startsWith("^") ? "^refs/for/" + name.substring("^".length()) : "refs/for/" + name;
        return config.getAccessSection(name, true).getPermission("pushMerge", true);
    }

    private static PermissionRule rule(GroupReference group) {
        return new PermissionRule(group);
    }

    private static PermissionRule deny(GroupReference group) {
        PermissionRule rule = Schema_53.rule(group);
        rule.setDeny();
        return rule;
    }

    private int inheritedMax(ProjectConfig config, OldRefRight old) {
        int max = 0;
        String ref = old.ref_pattern;
        String category = old.category;
        AccountGroup.UUID group = old.group.getUUID();
        Project.NameKey project = config.getProject().getParent();
        if (project == null) {
            project = this.systemConfig.wildProjectName;
        }
        block0: do {
            List<OldRefRight> rights;
            if ((rights = this.rightsByProject.get(project)) == null) continue;
            for (OldRefRight r : rights) {
                if (!r.ref_pattern.equals(ref) || !r.group.getUUID().equals(group) || !r.category.equals(category)) continue;
                max = Math.max(max, r.max_value);
                continue block0;
            }
        } while (!(project = this.parentsByProject.get(project)).equals(this.systemConfig.wildProjectName));
        return max;
    }

    private static void add(AccessSection section, String name, boolean exclusive, PermissionRule rule) {
        Permission p = section.getPermission(name, true);
        if (exclusive) {
            p.setExclusiveGroup(true);
        }
        p.add(rule);
    }

    private class OldRefRight {
        final int min_value;
        final int max_value;
        final String ref_pattern;
        final boolean exclusive;
        final GroupReference group;
        final String category;
        final Project.NameKey project;

        OldRefRight(ResultSet rs) throws SQLException {
            this.min_value = rs.getInt("min_value");
            this.max_value = rs.getInt("max_value");
            this.project = new Project.NameKey(rs.getString("project_name"));
            String r = rs.getString("ref_pattern");
            this.exclusive = r.startsWith("-");
            if (this.exclusive) {
                r = r.substring(1);
            }
            this.ref_pattern = r;
            this.category = rs.getString("category_id");
            this.group = (GroupReference)Schema_53.this.groupMap.get(new AccountGroup.Id(rs.getInt("group_id")));
        }
    }
}

