/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_66;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Schema_67
extends SchemaVersion {
    @Inject
    Schema_67(Provider<Schema_66> prior) {
        super(prior);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        ui.message("Update ownerGroupId to ownerGroupUUID");
        HashMap<AccountGroup.Id, AccountGroup.Id> idMap = Maps.newHashMap();
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();
             java.sql.ResultSet rs = stmt.executeQuery("SELECT group_id, owner_group_id FROM account_groups WHERE owner_group_uuid is NULL or owner_group_uuid =''");){
            while (rs.next()) {
                AccountGroup.Id groupId = new AccountGroup.Id(rs.getInt(1));
                AccountGroup.Id ownerId = new AccountGroup.Id(rs.getInt(2));
                idMap.put(groupId, ownerId);
            }
        }
        HashSet all = Sets.newHashSet(Iterables.concat(idMap.keySet(), idMap.values()));
        HashMap<AccountGroup.Id, AccountGroup> groups = Maps.newHashMap();
        try (ResultSet rs = db.accountGroups().get(all);){
            for (AccountGroup group : rs) {
                groups.put(group.getId(), group);
            }
        }
        ArrayList<AccountGroup> toUpdate = Lists.newArrayListWithCapacity(idMap.size());
        for (Map.Entry entry : idMap.entrySet()) {
            AccountGroup group = (AccountGroup)groups.get(entry.getKey());
            AccountGroup owner = (AccountGroup)groups.get(entry.getValue());
            group.setOwnerGroupUUID(owner.getGroupUUID());
            toUpdate.add(group);
        }
        db.accountGroups().update(toUpdate);
    }
}

