/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gerrit.audit.AuditService;
import com.google.gerrit.audit.SshAuditEvent;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PeerDaemonUser;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.util.IdGenerator;
import com.google.gerrit.server.util.SystemLog;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gerrit.sshd.DispatchCommand;
import com.google.gerrit.sshd.SshLogLayout;
import com.google.gerrit.sshd.SshScope;
import com.google.gerrit.sshd.SshSession;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.jgit.lib.Config;

@Singleton
class SshLog
implements LifecycleListener {
    private static final Logger log = Logger.getLogger(SshLog.class);
    private static final String LOG_NAME = "sshd_log";
    private static final String P_SESSION = "session";
    private static final String P_USER_NAME = "userName";
    private static final String P_ACCOUNT_ID = "accountId";
    private static final String P_WAIT = "queueWaitTime";
    private static final String P_EXEC = "executionTime";
    private static final String P_STATUS = "status";
    private final Provider<SshSession> session;
    private final Provider<SshScope.Context> context;
    private final AsyncAppender async;
    private final AuditService auditService;

    @Inject
    SshLog(Provider<SshSession> session, Provider<SshScope.Context> context, SystemLog systemLog, @GerritServerConfig Config config, AuditService auditService) {
        this.session = session;
        this.context = context;
        this.auditService = auditService;
        if (!config.getBoolean("sshd", "requestLog", true)) {
            this.async = null;
            return;
        }
        this.async = systemLog.createAsyncAppender(LOG_NAME, new SshLogLayout());
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.async != null) {
            this.async.close();
        }
    }

    void onLogin() {
        LoggingEvent entry = this.log("LOGIN FROM " + this.session.get().getRemoteAddressAsString());
        if (this.async != null) {
            this.async.append(entry);
        }
        this.audit(this.context.get(), (Object)"0", "LOGIN");
    }

    void onAuthFail(SshSession sd) {
        LoggingEvent event = new LoggingEvent(Logger.class.getName(), log, TimeUtil.nowMs(), Level.INFO, "AUTH FAILURE FROM " + sd.getRemoteAddressAsString(), "SSHD", null, null, null, null);
        event.setProperty(P_SESSION, SshLog.id(sd.getSessionId()));
        event.setProperty(P_USER_NAME, sd.getUsername());
        String error = sd.getAuthenticationError();
        if (error != null) {
            event.setProperty(P_STATUS, error);
        }
        if (this.async != null) {
            this.async.append(event);
        }
        this.audit(null, (Object)"FAIL", "AUTH");
    }

    void onExecute(DispatchCommand dcmd, int exitValue) {
        String status;
        SshScope.Context ctx = this.context.get();
        ctx.finished = TimeUtil.nowMs();
        String cmd = this.extractWhat(dcmd);
        LoggingEvent event = this.log(cmd);
        event.setProperty(P_WAIT, ctx.started - ctx.created + "ms");
        event.setProperty(P_EXEC, ctx.finished - ctx.started + "ms");
        switch (exitValue) {
            case 0x40000001: {
                status = "killed";
                break;
            }
            case 0x40000002: {
                status = "not-found";
                break;
            }
            case 0x40000003: {
                status = "not-admin";
                break;
            }
            default: {
                status = String.valueOf(exitValue);
            }
        }
        event.setProperty(P_STATUS, status);
        if (this.async != null) {
            this.async.append(event);
        }
        this.audit(this.context.get(), (Object)status, dcmd);
    }

    private Multimap<String, ?> extractParameters(DispatchCommand dcmd) {
        String[] cmdArgs = dcmd.getArguments();
        String paramName = null;
        int argPos = 0;
        ArrayListMultimap<String, String> parms = ArrayListMultimap.create();
        for (int i = 2; i < cmdArgs.length; ++i) {
            String arg = cmdArgs[i];
            if (arg.equals("--")) {
                ++i;
                while (i < cmdArgs.length) {
                    parms.put("$" + argPos++, cmdArgs[i]);
                    ++i;
                }
                break;
            }
            int eqPos = arg.indexOf(61);
            if (arg.startsWith("--") && eqPos > 0) {
                parms.put(arg.substring(0, eqPos), arg.substring(eqPos + 1));
                continue;
            }
            if (arg.startsWith("-")) {
                if (paramName != null) {
                    parms.put(paramName, null);
                }
                paramName = arg;
                continue;
            }
            if (paramName == null) {
                parms.put("$" + argPos++, arg);
                continue;
            }
            parms.put(paramName, arg);
            paramName = null;
        }
        if (paramName != null) {
            parms.put(paramName, null);
        }
        return parms;
    }

    void onLogout() {
        LoggingEvent entry = this.log("LOGOUT");
        if (this.async != null) {
            this.async.append(entry);
        }
        this.audit(this.context.get(), (Object)"0", "LOGOUT");
    }

    private LoggingEvent log(String msg) {
        SshSession sd = this.session.get();
        CurrentUser user = sd.getCurrentUser();
        LoggingEvent event = new LoggingEvent(Logger.class.getName(), log, TimeUtil.nowMs(), Level.INFO, msg, "SSHD", null, null, null, null);
        event.setProperty(P_SESSION, SshLog.id(sd.getSessionId()));
        String userName = "-";
        String accountId = "-";
        if (user != null && user.isIdentifiedUser()) {
            IdentifiedUser u = (IdentifiedUser)user;
            userName = u.getAccount().getUserName();
            accountId = "a/" + u.getAccountId().toString();
        } else if (user instanceof PeerDaemonUser) {
            userName = "Gerrit Code Review";
        }
        event.setProperty(P_USER_NAME, userName);
        event.setProperty(P_ACCOUNT_ID, accountId);
        return event;
    }

    private static String id(int id) {
        return IdGenerator.format(id);
    }

    void audit(SshScope.Context ctx, Object result, String cmd) {
        this.audit(ctx, result, cmd, null);
    }

    void audit(SshScope.Context ctx, Object result, DispatchCommand cmd) {
        this.audit(ctx, result, this.extractWhat(cmd), this.extractParameters(cmd));
    }

    private void audit(SshScope.Context ctx, Object result, String cmd, Multimap<String, ?> params) {
        long created;
        CurrentUser currentUser;
        String sessionId;
        if (ctx == null) {
            sessionId = null;
            currentUser = null;
            created = TimeUtil.nowMs();
        } else {
            SshSession session = ctx.getSession();
            sessionId = IdGenerator.format(session.getSessionId());
            currentUser = session.getCurrentUser();
            created = ctx.created;
        }
        this.auditService.dispatch(new SshAuditEvent(sessionId, currentUser, cmd, created, params, result));
    }

    private String extractWhat(DispatchCommand dcmd) {
        String commandName = dcmd.getCommandName();
        for (String arg : dcmd.getArguments()) {
            commandName = commandName + "." + arg;
        }
        return commandName;
    }
}

