/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.jgit.util.QuotedString;

public final class SshLogLayout
extends Layout {
    private static final String P_SESSION = "session";
    private static final String P_USER_NAME = "userName";
    private static final String P_ACCOUNT_ID = "accountId";
    private static final String P_WAIT = "queueWaitTime";
    private static final String P_EXEC = "executionTime";
    private static final String P_STATUS = "status";
    private final Calendar calendar;
    private long lastTimeMillis;
    private final char[] lastTimeString = new char[20];
    private final char[] timeZone;

    public SshLogLayout() {
        TimeZone tz = TimeZone.getDefault();
        this.calendar = Calendar.getInstance(tz);
        SimpleDateFormat sdf = new SimpleDateFormat("Z");
        sdf.setTimeZone(tz);
        this.timeZone = sdf.format(new Date()).toCharArray();
    }

    @Override
    public String format(LoggingEvent event) {
        StringBuffer buf = new StringBuffer(128);
        buf.append('[');
        this.formatDate(event.getTimeStamp(), buf);
        buf.append(' ');
        buf.append(this.timeZone);
        buf.append(']');
        this.req(P_SESSION, buf, event);
        this.req(P_USER_NAME, buf, event);
        this.req(P_ACCOUNT_ID, buf, event);
        buf.append(' ');
        buf.append(event.getMessage());
        this.opt(P_WAIT, buf, event);
        this.opt(P_EXEC, buf, event);
        this.opt(P_STATUS, buf, event);
        buf.append('\n');
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatDate(long now, StringBuffer sbuf) {
        int millis = (int)(now % 1000L);
        long rounded = now - (long)millis;
        if (rounded != this.lastTimeMillis) {
            Calendar calendar = this.calendar;
            synchronized (calendar) {
                int start = sbuf.length();
                this.calendar.setTimeInMillis(rounded);
                sbuf.append(this.calendar.get(1));
                sbuf.append('-');
                sbuf.append(this.toTwoDigits(this.calendar.get(2) + 1));
                sbuf.append('-');
                sbuf.append(this.toTwoDigits(this.calendar.get(5)));
                sbuf.append(' ');
                sbuf.append(this.toTwoDigits(this.calendar.get(11)));
                sbuf.append(':');
                sbuf.append(this.toTwoDigits(this.calendar.get(12)));
                sbuf.append(':');
                sbuf.append(this.toTwoDigits(this.calendar.get(13)));
                sbuf.append(',');
                sbuf.getChars(start, sbuf.length(), this.lastTimeString, 0);
                this.lastTimeMillis = rounded;
            }
        } else {
            sbuf.append(this.lastTimeString);
        }
        sbuf.append(String.format("%03d", millis));
    }

    private String toTwoDigits(int input) {
        return String.format("%02d", input);
    }

    private void req(String key, StringBuffer buf, LoggingEvent event) {
        Object val = event.getMDC(key);
        buf.append(' ');
        if (val != null) {
            String s = val.toString();
            if (0 <= s.indexOf(32)) {
                buf.append(QuotedString.BOURNE.quote(s));
            } else {
                buf.append(val);
            }
        } else {
            buf.append('-');
        }
    }

    private void opt(String key, StringBuffer buf, LoggingEvent event) {
        Object val = event.getMDC(key);
        if (val != null) {
            buf.append(' ');
            buf.append(val);
        }
    }

    @Override
    public boolean ignoresThrowable() {
        return true;
    }

    @Override
    public void activateOptions() {
    }
}

