/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.restapi;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.common.math.IntMath;
import com.google.gerrit.audit.AuditService;
import com.google.gerrit.audit.HttpAuditEvent;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.AcceptsPost;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.CacheControl;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.PreconditionFailedException;
import com.google.gerrit.extensions.restapi.RawInput;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestCollection;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.httpd.restapi.ParameterParser;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.OptionUtil;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.account.CapabilityUtils;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.util.Providers;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestApiServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RestApiServlet.class);
    private static final String JSON_TYPE = "application/json";
    private static final String FORM_TYPE = "application/x-www-form-urlencoded";
    public static final byte[] JSON_MAGIC = ")]}'\n".getBytes(StandardCharsets.UTF_8);
    private final Globals globals;
    private final Provider<RestCollection<RestResource, RestResource>> members;
    private static final Pattern IS_HTML = Pattern.compile("[<&]");

    public RestApiServlet(Globals globals, RestCollection<? extends RestResource, ? extends RestResource> members) {
        this(globals, Providers.of(members));
    }

    public RestApiServlet(Globals globals, Provider<? extends RestCollection<? extends RestResource, ? extends RestResource>> members) {
        Provider<? extends RestCollection<? extends RestResource, ? extends RestResource>> n = Preconditions.checkNotNull(members);
        this.globals = globals;
        this.members = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        long auditStartTs = TimeUtil.nowMs();
        res.setHeader("Content-Disposition", "attachment");
        res.setHeader("X-Content-Type-Options", "nosniff");
        int status = 200;
        Object result = null;
        LinkedHashMultimap<String, String> params = LinkedHashMultimap.create();
        Object inputRequestBody = null;
        try {
            this.checkUserSession(req);
            List<IdString> path = RestApiServlet.splitPath(req);
            RestCollection<RestResource, RestResource> rc = this.members.get();
            CapabilityUtils.checkRequiresCapability(this.globals.currentUser, null, rc.getClass());
            RestResource rsrc = TopLevelResource.INSTANCE;
            ViewData viewData = new ViewData(null, null);
            if (path.isEmpty()) {
                if (RestApiServlet.isGetOrHead(req)) {
                    viewData = new ViewData(null, rc.list());
                } else {
                    if (!(rc instanceof AcceptsPost)) throw new MethodNotAllowedException();
                    if (!"POST".equals(req.getMethod())) throw new MethodNotAllowedException();
                    AcceptsPost ac = (AcceptsPost)((Object)rc);
                    viewData = new ViewData(null, ac.post(rsrc));
                }
            } else {
                IdString id = path.remove(0);
                try {
                    rsrc = rc.parse(rsrc, id);
                    if (path.isEmpty()) {
                        this.checkPreconditions(req, rsrc);
                    }
                }
                catch (ResourceNotFoundException e) {
                    if (!(rc instanceof AcceptsCreate)) throw e;
                    if (!path.isEmpty()) throw e;
                    if (!"POST".equals(req.getMethod())) {
                        if (!"PUT".equals(req.getMethod())) throw e;
                    }
                    AcceptsCreate ac = (AcceptsCreate)((Object)rc);
                    viewData = new ViewData(null, ac.create(rsrc, id));
                    status = 201;
                }
                if (viewData.view == null) {
                    viewData = this.view(rsrc, rc, req.getMethod(), path);
                }
            }
            this.checkRequiresCapability(viewData);
            while (viewData.view instanceof RestCollection) {
                RestCollection c = (RestCollection)((Object)viewData.view);
                if (path.isEmpty()) {
                    if (RestApiServlet.isGetOrHead(req)) {
                        viewData = new ViewData(null, c.list());
                        break;
                    }
                    if (!(c instanceof AcceptsPost)) throw new MethodNotAllowedException();
                    if (!"POST".equals(req.getMethod())) throw new MethodNotAllowedException();
                    AcceptsPost ac = (AcceptsPost)((Object)c);
                    viewData = new ViewData(null, ac.post(rsrc));
                    break;
                }
                IdString id = path.remove(0);
                try {
                    rsrc = c.parse(rsrc, id);
                    this.checkPreconditions(req, rsrc);
                    viewData = new ViewData(null, null);
                }
                catch (ResourceNotFoundException e) {
                    if (!(c instanceof AcceptsCreate)) throw e;
                    if (!path.isEmpty()) throw e;
                    if (!"POST".equals(req.getMethod())) {
                        if (!"PUT".equals(req.getMethod())) throw e;
                    }
                    AcceptsCreate ac = (AcceptsCreate)((Object)c);
                    viewData = new ViewData(viewData.pluginName, ac.create(rsrc, id));
                    status = 201;
                }
                if (viewData.view == null) {
                    viewData = this.view(rsrc, c, req.getMethod(), path);
                }
                this.checkRequiresCapability(viewData);
            }
            if (RestApiServlet.notModified(req, rsrc)) {
                res.sendError(304);
                return;
            }
            LinkedHashMultimap<String, String> config = LinkedHashMultimap.create();
            ParameterParser.splitQueryString(req.getQueryString(), config, params);
            if (!this.globals.paramParser.get().parse(viewData.view, params, req, res)) {
                this.globals.auditService.dispatch(new HttpAuditEvent(this.globals.webSession.get().getSessionId(), this.globals.currentUser.get(), req.getRequestURI(), auditStartTs, params, req.getMethod(), inputRequestBody, status, result));
                return;
            }
            if (viewData.view instanceof RestModifyView) {
                RestModifyView m = (RestModifyView)viewData.view;
                inputRequestBody = this.parseRequest(req, RestApiServlet.inputType(m));
                result = m.apply(rsrc, inputRequestBody);
            } else {
                if (!(viewData.view instanceof RestReadView)) throw new ResourceNotFoundException();
                result = ((RestReadView)viewData.view).apply(rsrc);
            }
            if (result instanceof Response) {
                Response r = (Response)result;
                status = r.statusCode();
                RestApiServlet.configureCaching(req, res, rsrc, r.caching());
            } else {
                if (result instanceof Response.Redirect) {
                    CacheHeaders.setNotCacheable(res);
                    res.sendRedirect(((Response.Redirect)result).location());
                    this.globals.auditService.dispatch(new HttpAuditEvent(this.globals.webSession.get().getSessionId(), this.globals.currentUser.get(), req.getRequestURI(), auditStartTs, params, req.getMethod(), inputRequestBody, status, result));
                    return;
                }
                CacheHeaders.setNotCacheable(res);
            }
            res.setStatus(status);
            if (result != Response.none()) {
                if ((result = Response.unwrap(result)) instanceof BinaryResult) {
                    RestApiServlet.replyBinaryResult(req, res, (BinaryResult)result);
                } else {
                    RestApiServlet.replyJson(req, res, config, result);
                }
            }
            this.globals.auditService.dispatch(new HttpAuditEvent(this.globals.webSession.get().getSessionId(), this.globals.currentUser.get(), req.getRequestURI(), auditStartTs, params, req.getMethod(), inputRequestBody, status, result));
            return;
        }
        catch (AuthException e) {
            status = 403;
            RestApiServlet.replyError(req, res, 403, e.getMessage(), e.caching());
            return;
        }
        catch (BadRequestException e) {
            status = 400;
            RestApiServlet.replyError(req, res, 400, e.getMessage(), e.caching());
            return;
        }
        catch (MethodNotAllowedException e) {
            status = 405;
            RestApiServlet.replyError(req, res, 405, "Method not allowed", e.caching());
            return;
        }
        catch (ResourceConflictException e) {
            status = 409;
            RestApiServlet.replyError(req, res, 409, e.getMessage(), e.caching());
            return;
        }
        catch (PreconditionFailedException e) {
            status = 412;
            RestApiServlet.replyError(req, res, 412, Objects.firstNonNull(e.getMessage(), "Precondition failed"), e.caching());
            return;
        }
        catch (ResourceNotFoundException e) {
            status = 404;
            RestApiServlet.replyError(req, res, 404, "Not found", e.caching());
            return;
        }
        catch (UnprocessableEntityException e) {
            status = 422;
            RestApiServlet.replyError(req, res, 422, Objects.firstNonNull(e.getMessage(), "Unprocessable Entity"), e.caching());
            return;
        }
        catch (AmbiguousViewException e) {
            status = 404;
            RestApiServlet.replyError(req, res, 404, e.getMessage());
            return;
        }
        catch (MalformedJsonException e) {
            status = 400;
            RestApiServlet.replyError(req, res, 400, "Invalid application/json in request");
            return;
        }
        catch (JsonParseException e) {
            status = 400;
            RestApiServlet.replyError(req, res, 400, "Invalid application/json in request");
            return;
        }
        catch (Exception e) {
            status = 500;
            RestApiServlet.handleException(e, req, res);
            return;
        }
        finally {
            this.globals.auditService.dispatch(new HttpAuditEvent(this.globals.webSession.get().getSessionId(), this.globals.currentUser.get(), req.getRequestURI(), auditStartTs, params, req.getMethod(), inputRequestBody, status, result));
        }
    }

    private static boolean notModified(HttpServletRequest req, RestResource rsrc) {
        String have;
        if (!RestApiServlet.isGetOrHead(req)) {
            return false;
        }
        if (rsrc instanceof RestResource.HasETag && (have = req.getHeader("If-None-Match")) != null) {
            return have.equals(((RestResource.HasETag)((Object)rsrc)).getETag());
        }
        if (rsrc instanceof RestResource.HasLastModified) {
            Timestamp m = ((RestResource.HasLastModified)((Object)rsrc)).getLastModified();
            long d = req.getDateHeader("If-Modified-Since");
            return d / 1000L == m.getTime() / 1000L;
        }
        return false;
    }

    private static <T> void configureCaching(HttpServletRequest req, HttpServletResponse res, RestResource rsrc, CacheControl c) {
        if (RestApiServlet.isGetOrHead(req)) {
            switch (c.getType()) {
                default: {
                    CacheHeaders.setNotCacheable(res);
                    break;
                }
                case PRIVATE: {
                    RestApiServlet.addResourceStateHeaders(res, rsrc);
                    CacheHeaders.setCacheablePrivate(res, c.getAge(), c.getUnit(), c.isMustRevalidate());
                    break;
                }
                case PUBLIC: {
                    RestApiServlet.addResourceStateHeaders(res, rsrc);
                    CacheHeaders.setCacheable(req, res, c.getAge(), c.getUnit(), c.isMustRevalidate());
                    break;
                }
            }
        } else {
            CacheHeaders.setNotCacheable(res);
        }
    }

    private static void addResourceStateHeaders(HttpServletResponse res, RestResource rsrc) {
        if (rsrc instanceof RestResource.HasETag) {
            res.setHeader("ETag", ((RestResource.HasETag)((Object)rsrc)).getETag());
        }
        if (rsrc instanceof RestResource.HasLastModified) {
            res.setDateHeader("Last-Modified", ((RestResource.HasLastModified)((Object)rsrc)).getLastModified().getTime());
        }
    }

    private void checkPreconditions(HttpServletRequest req, RestResource rsrc) throws PreconditionFailedException {
        if ("*".equals(req.getHeader("If-None-Match"))) {
            throw new PreconditionFailedException("Resource already exists");
        }
    }

    private static Type inputType(RestModifyView<RestResource, Object> m) {
        Type inputType = RestApiServlet.extractInputType(m.getClass());
        if (inputType == null) {
            throw new IllegalStateException(String.format("View %s does not correctly implement %s", m.getClass(), RestModifyView.class.getSimpleName()));
        }
        return inputType;
    }

    private static Type extractInputType(Class clazz) {
        Type i;
        for (Type type : clazz.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType) || ((ParameterizedType)type).getRawType() != RestModifyView.class) continue;
            return ((ParameterizedType)type).getActualTypeArguments()[1];
        }
        if (clazz.getSuperclass() != null && (i = RestApiServlet.extractInputType(clazz.getSuperclass())) != null) {
            return i;
        }
        for (Type type : clazz.getInterfaces()) {
            Type i2 = RestApiServlet.extractInputType((Class)type);
            if (i2 == null) continue;
            return i2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseRequest(HttpServletRequest req, Type type) throws IOException, BadRequestException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException, MethodNotAllowedException {
        if (RestApiServlet.isType(JSON_TYPE, req.getContentType())) {
            try (BufferedReader br = req.getReader();){
                JsonToken first;
                JsonReader json = new JsonReader(br);
                json.setLenient(true);
                try {
                    first = json.peek();
                }
                catch (EOFException e) {
                    throw new BadRequestException("Expected JSON object");
                }
                if (first == JsonToken.STRING) {
                    Object e = this.parseString(json.nextString(), type);
                    return e;
                }
                Object e = OutputFormat.JSON.newGson().fromJson(json, type);
                return e;
            }
        }
        if (("PUT".equals(req.getMethod()) || "POST".equals(req.getMethod())) && RestApiServlet.acceptsRawInput(type)) {
            return this.parseRawInput(req, type);
        }
        if ("DELETE".equals(req.getMethod()) && RestApiServlet.hasNoBody(req)) {
            return null;
        }
        if (RestApiServlet.hasNoBody(req)) {
            return RestApiServlet.createInstance(type);
        }
        if (RestApiServlet.isType("text/plain", req.getContentType())) {
            try (BufferedReader br = req.getReader();){
                int n;
                char[] tmp = new char[256];
                StringBuilder sb = new StringBuilder();
                while (0 < (n = br.read(tmp))) {
                    sb.append(tmp, 0, n);
                }
                Object object = this.parseString(sb.toString(), type);
                return object;
            }
        }
        if ("POST".equals(req.getMethod()) && RestApiServlet.isType(FORM_TYPE, req.getContentType())) {
            return OutputFormat.JSON.newGson().fromJson((JsonElement)ParameterParser.formToJson(req), type);
        }
        throw new BadRequestException("Expected Content-Type: application/json");
    }

    private static boolean hasNoBody(HttpServletRequest req) {
        int len = req.getContentLength();
        String type = req.getContentType();
        return len <= 0 && type == null || len == 0 && RestApiServlet.isType(FORM_TYPE, type);
    }

    private static boolean acceptsRawInput(Type type) {
        if (type instanceof Class) {
            for (Field f : ((Class)type).getDeclaredFields()) {
                if (f.getType() != RawInput.class) continue;
                return true;
            }
        }
        return false;
    }

    private Object parseRawInput(final HttpServletRequest req, Type type) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, MethodNotAllowedException {
        Object obj = RestApiServlet.createInstance(type);
        for (Field f : obj.getClass().getDeclaredFields()) {
            if (f.getType() != RawInput.class) continue;
            f.setAccessible(true);
            f.set(obj, new RawInput(){

                @Override
                public String getContentType() {
                    return req.getContentType();
                }

                @Override
                public long getContentLength() {
                    return req.getContentLength();
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return req.getInputStream();
                }
            });
            return obj;
        }
        throw new MethodNotAllowedException();
    }

    private Object parseString(String value, Type type) throws BadRequestException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (type == String.class) {
            return value;
        }
        Object obj = RestApiServlet.createInstance(type);
        Field[] fields = obj.getClass().getDeclaredFields();
        if (fields.length == 0 && Strings.isNullOrEmpty(value)) {
            return obj;
        }
        for (Field f : fields) {
            if (f.getAnnotation(DefaultInput.class) == null || f.getType() != String.class) continue;
            f.setAccessible(true);
            f.set(obj, value);
            return obj;
        }
        throw new BadRequestException("Expected JSON object");
    }

    private static Object createInstance(Type type) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            Constructor c = clazz.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return c.newInstance(new Object[0]);
        }
        throw new InstantiationException("Cannot make " + type);
    }

    public static void replyJson(@Nullable HttpServletRequest req, HttpServletResponse res, Multimap<String, String> config, Object result) throws IOException {
        TemporaryBuffer.Heap buf = RestApiServlet.heap(Integer.MAX_VALUE);
        buf.write(JSON_MAGIC);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, StandardCharsets.UTF_8));
        Gson gson = RestApiServlet.newGson(config, req);
        if (result instanceof JsonElement) {
            gson.toJson((JsonElement)result, (Appendable)w);
        } else {
            gson.toJson(result, (Appendable)w);
        }
        ((Writer)w).write(10);
        ((Writer)w).flush();
        RestApiServlet.replyBinaryResult(req, res, RestApiServlet.asBinaryResult(buf).setContentType(JSON_TYPE).setCharacterEncoding(StandardCharsets.UTF_8.name()));
    }

    private static Gson newGson(Multimap<String, String> config, @Nullable HttpServletRequest req) {
        GsonBuilder gb = OutputFormat.JSON_COMPACT.newGsonBuilder();
        RestApiServlet.enablePrettyPrint(gb, config, req);
        RestApiServlet.enablePartialGetFields(gb, config);
        return gb.create();
    }

    private static void enablePrettyPrint(GsonBuilder gb, Multimap<String, String> config, @Nullable HttpServletRequest req) {
        String pp = Iterables.getFirst(config.get("pp"), null);
        if (pp == null && (pp = (String)Iterables.getFirst(config.get("prettyPrint"), null)) == null && req != null) {
            String string = pp = RestApiServlet.acceptsJson(req) ? "0" : "1";
        }
        if ("1".equals(pp) || "true".equals(pp)) {
            gb.setPrettyPrinting();
        }
    }

    private static void enablePartialGetFields(GsonBuilder gb, Multimap<String, String> config) {
        final HashSet want = Sets.newHashSet();
        for (String p : config.get("fields")) {
            Iterables.addAll(want, OptionUtil.splitOptionValue(p));
        }
        if (!want.isEmpty()) {
            gb.addSerializationExclusionStrategy(new ExclusionStrategy(){
                private final Map<String, String> names = Maps.newHashMap();

                @Override
                public boolean shouldSkipField(FieldAttributes field) {
                    String name = this.names.get(field.getName());
                    if (name == null) {
                        try {
                            name = FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES.translateName(field.getDeclaringClass().getDeclaredField(field.getName()));
                            this.names.put(field.getName(), name);
                        }
                        catch (SecurityException e) {
                            return true;
                        }
                        catch (NoSuchFieldException e) {
                            return true;
                        }
                    }
                    return !want.contains(name);
                }

                @Override
                public boolean shouldSkipClass(Class<?> clazz) {
                    return false;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void replyBinaryResult(@Nullable HttpServletRequest req, HttpServletResponse res, BinaryResult bin) throws IOException {
        block12: {
            try (BinaryResult appResult = bin;){
                if (bin.getAttachmentName() != null) {
                    res.setHeader("Content-Disposition", "attachment; filename=\"" + bin.getAttachmentName() + "\"");
                }
                if (bin.isBase64()) {
                    bin = RestApiServlet.stackBase64(res, bin);
                }
                if (bin.canGzip() && RestApiServlet.acceptsGzip(req)) {
                    bin = RestApiServlet.stackGzip(res, bin);
                }
                res.setContentType(bin.getContentType());
                long len = bin.getContentLength();
                if (0L <= len && len < Integer.MAX_VALUE) {
                    res.setContentLength((int)len);
                } else if (0L <= len) {
                    res.setHeader("Content-Length", Long.toString(len));
                }
                if (req != null && "HEAD".equals(req.getMethod())) break block12;
                try (ServletOutputStream dst = res.getOutputStream();){
                    bin.writeTo(dst);
                }
            }
        }
    }

    private static BinaryResult stackBase64(HttpServletResponse res, final BinaryResult src) throws IOException {
        long len = src.getContentLength();
        BinaryResult b64 = 0L <= len && len <= 0x700000L ? RestApiServlet.base64(src) : new BinaryResult(){

            @Override
            public void writeTo(OutputStream out) throws IOException {
                OutputStream e = BaseEncoding.base64().encodingStream(new OutputStreamWriter(out, StandardCharsets.ISO_8859_1));
                src.writeTo(e);
                e.flush();
            }
        };
        res.setHeader("X-FYI-Content-Encoding", "base64");
        res.setHeader("X-FYI-Content-Type", src.getContentType());
        return b64.setContentType("text/plain").setCharacterEncoding("ISO-8859-1");
    }

    private static BinaryResult stackGzip(HttpServletResponse res, final BinaryResult src) throws IOException {
        BinaryResult gz;
        long len = src.getContentLength();
        if (256L <= len && len <= 0xA00000L) {
            gz = RestApiServlet.compress(src);
            if (len <= gz.getContentLength()) {
                return src;
            }
        } else {
            gz = new BinaryResult(){

                @Override
                public void writeTo(OutputStream out) throws IOException {
                    GZIPOutputStream gz = new GZIPOutputStream(out);
                    src.writeTo(gz);
                    gz.finish();
                    gz.flush();
                }
            };
        }
        res.setHeader("Content-Encoding", "gzip");
        return gz.setContentType(src.getContentType());
    }

    private ViewData view(RestResource rsrc, RestCollection<RestResource, RestResource> rc, String method, List<IdString> path) throws AmbiguousViewException, RestApiException {
        IdString projection;
        DynamicMap<RestView<RestResource>> views = rc.views();
        IdString idString = projection = path.isEmpty() ? IdString.fromUrl("/") : path.remove(0);
        if (!path.isEmpty()) {
            method = "GET";
        } else if ("HEAD".equals(method)) {
            method = "GET";
        }
        List<String> p = RestApiServlet.splitProjection(projection);
        if (p.size() == 2) {
            RestView<RestResource> view;
            String viewname = p.get(1);
            if (Strings.isNullOrEmpty(viewname)) {
                viewname = "/";
            }
            if ((view = views.get(p.get(0), method + "." + viewname)) != null) {
                return new ViewData(p.get(0), view);
            }
            view = views.get(p.get(0), "GET." + viewname);
            if (view != null && view instanceof AcceptsPost && "POST".equals(method)) {
                AcceptsPost ap = (AcceptsPost)((Object)view);
                return new ViewData(p.get(0), ap.post(rsrc));
            }
            throw new ResourceNotFoundException(projection);
        }
        String name = method + "." + p.get(0);
        RestView<RestResource> core = views.get("gerrit", name);
        if (core != null) {
            return new ViewData(null, core);
        }
        core = views.get("gerrit", "GET." + p.get(0));
        if (core instanceof AcceptsPost && "POST".equals(method)) {
            AcceptsPost ap = (AcceptsPost)((Object)core);
            return new ViewData(null, ap.post(rsrc));
        }
        TreeMap<String, RestView<RestResource>> r = Maps.newTreeMap();
        for (String plugin : views.plugins()) {
            RestView<RestResource> action = views.get(plugin, name);
            if (action == null) continue;
            r.put(plugin, action);
        }
        if (r.size() == 1) {
            Map.Entry entry = Iterables.getOnlyElement(r.entrySet());
            return new ViewData((String)entry.getKey(), (RestView)entry.getValue());
        }
        if (r.isEmpty()) {
            throw new ResourceNotFoundException(projection);
        }
        throw new AmbiguousViewException(String.format("Projection %s is ambiguous: %s", name, Joiner.on(", ").join(Iterables.transform(r.keySet(), new Function<String, String>(){

            @Override
            public String apply(String in) {
                return in + "~" + projection;
            }
        }))));
    }

    private static List<IdString> splitPath(HttpServletRequest req) {
        String path = req.getPathInfo();
        if (Strings.isNullOrEmpty(path)) {
            return Collections.emptyList();
        }
        ArrayList<IdString> out = Lists.newArrayList();
        for (String p : Splitter.on('/').split(path)) {
            out.add(IdString.fromUrl(p));
        }
        if (out.size() > 0 && ((IdString)out.get(out.size() - 1)).isEmpty()) {
            out.remove(out.size() - 1);
        }
        return out;
    }

    private static List<String> splitProjection(IdString projection) {
        ArrayList<String> p = Lists.newArrayListWithCapacity(2);
        Iterables.addAll(p, Splitter.on('~').limit(2).split(projection.get()));
        return p;
    }

    private void checkUserSession(HttpServletRequest req) throws AuthException {
        CurrentUser user = this.globals.currentUser.get();
        if (RestApiServlet.isStateChange(req)) {
            if (user instanceof AnonymousUser) {
                throw new AuthException("Authentication required");
            }
            if (!this.globals.webSession.get().isAccessPathOk(AccessPath.REST_API)) {
                throw new AuthException("Invalid authentication method. In order to authenticate, prefix the REST endpoint URL with /a/ (e.g. http://example.com/a/projects/).");
            }
        }
        user.setAccessPath(AccessPath.REST_API);
    }

    private static boolean isGetOrHead(HttpServletRequest req) {
        return "GET".equals(req.getMethod()) || "HEAD".equals(req.getMethod());
    }

    private static boolean isStateChange(HttpServletRequest req) {
        return !RestApiServlet.isGetOrHead(req);
    }

    private void checkRequiresCapability(ViewData viewData) throws AuthException {
        CapabilityUtils.checkRequiresCapability(this.globals.currentUser, viewData.pluginName, viewData.view.getClass());
    }

    private static void handleException(Throwable err, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String uri = req.getRequestURI();
        if (!Strings.isNullOrEmpty(req.getQueryString())) {
            uri = uri + "?" + req.getQueryString();
        }
        log.error(String.format("Error in %s %s", req.getMethod(), uri), err);
        if (!res.isCommitted()) {
            res.reset();
            RestApiServlet.replyError(req, res, 500, "Internal server error");
        }
    }

    public static void replyError(HttpServletRequest req, HttpServletResponse res, int statusCode, String msg) throws IOException {
        RestApiServlet.replyError(req, res, statusCode, msg, CacheControl.NONE);
    }

    public static void replyError(HttpServletRequest req, HttpServletResponse res, int statusCode, String msg, CacheControl c) throws IOException {
        res.setStatus(statusCode);
        RestApiServlet.configureCaching(req, res, null, c);
        RestApiServlet.replyText(req, res, msg);
    }

    static void replyText(@Nullable HttpServletRequest req, HttpServletResponse res, String text) throws IOException {
        if ((req == null || RestApiServlet.isGetOrHead(req)) && RestApiServlet.isMaybeHTML(text)) {
            RestApiServlet.replyJson(req, res, ImmutableMultimap.of("pp", "0"), new JsonPrimitive(text));
        } else {
            if (!text.endsWith("\n")) {
                text = text + "\n";
            }
            RestApiServlet.replyBinaryResult(req, res, BinaryResult.create(text).setContentType("text/plain"));
        }
    }

    private static boolean isMaybeHTML(String text) {
        return IS_HTML.matcher(text).find();
    }

    private static boolean acceptsJson(HttpServletRequest req) {
        return req != null && RestApiServlet.isType(JSON_TYPE, req.getHeader("Accept"));
    }

    private static boolean acceptsGzip(HttpServletRequest req) {
        if (req != null) {
            String accepts = req.getHeader("Accept-Encoding");
            return accepts != null && accepts.contains("gzip");
        }
        return false;
    }

    private static boolean isType(String expect, String given) {
        if (given == null) {
            return false;
        }
        if (expect.equals(given)) {
            return true;
        }
        if (given.startsWith(expect + ",")) {
            return true;
        }
        for (String p : given.split("[ ,;][ ,;]*")) {
            if (!expect.equals(p)) continue;
            return true;
        }
        return false;
    }

    private static BinaryResult base64(BinaryResult bin) throws IOException {
        int max = 4 * IntMath.divide((int)bin.getContentLength(), 3, RoundingMode.CEILING);
        TemporaryBuffer.Heap buf = RestApiServlet.heap(max);
        OutputStream encoded = BaseEncoding.base64().encodingStream(new OutputStreamWriter((OutputStream)buf, StandardCharsets.ISO_8859_1));
        bin.writeTo(encoded);
        encoded.close();
        return RestApiServlet.asBinaryResult(buf);
    }

    private static BinaryResult compress(BinaryResult bin) throws IOException {
        TemporaryBuffer.Heap buf = RestApiServlet.heap(0x1400000);
        GZIPOutputStream gz = new GZIPOutputStream(buf);
        bin.writeTo(gz);
        gz.close();
        return RestApiServlet.asBinaryResult(buf).setContentType(bin.getContentType());
    }

    private static BinaryResult asBinaryResult(final TemporaryBuffer.Heap buf) {
        return new BinaryResult(){

            @Override
            public void writeTo(OutputStream os) throws IOException {
                buf.writeTo(os, null);
            }
        }.setContentLength(buf.length());
    }

    private static TemporaryBuffer.Heap heap(int max) {
        return new TemporaryBuffer.Heap(max);
    }

    private static class ViewData {
        String pluginName;
        RestView<RestResource> view;

        ViewData(String pluginName, RestView<RestResource> view) {
            this.pluginName = pluginName;
            this.view = view;
        }
    }

    private static class AmbiguousViewException
    extends Exception {
        AmbiguousViewException(String message) {
            super(message);
        }
    }

    public static class Globals {
        final Provider<CurrentUser> currentUser;
        final DynamicItem<WebSession> webSession;
        final Provider<ParameterParser> paramParser;
        final AuditService auditService;

        @Inject
        Globals(Provider<CurrentUser> currentUser, DynamicItem<WebSession> webSession, Provider<ParameterParser> paramParser, AuditService auditService) {
            this.currentUser = currentUser;
            this.webSession = webSession;
            this.paramParser = paramParser;
            this.auditService = auditService;
        }
    }
}

