/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;

@Singleton
public class ChangeMessagesUtil {
    private final NotesMigration migration;

    private static List<ChangeMessage> sortChangeMessages(Iterable<ChangeMessage> changeMessage) {
        return ChangeNotes.MESSAGE_BY_TIME.sortedCopy(changeMessage);
    }

    @Inject
    @VisibleForTesting
    public ChangeMessagesUtil(NotesMigration migration) {
        this.migration = migration;
    }

    public List<ChangeMessage> byChange(ReviewDb db, ChangeNotes notes) throws OrmException {
        if (!this.migration.readChangeMessages()) {
            return ChangeMessagesUtil.sortChangeMessages(db.changeMessages().byChange(notes.getChangeId()));
        }
        return ChangeMessagesUtil.sortChangeMessages(((ChangeNotes)notes.load()).getChangeMessages().values());
    }

    public List<ChangeMessage> byPatchSet(ReviewDb db, ChangeNotes notes, PatchSet.Id psId) throws OrmException {
        if (!this.migration.readChangeMessages()) {
            return ChangeMessagesUtil.sortChangeMessages(db.changeMessages().byPatchSet(psId));
        }
        return ((ChangeNotes)notes.load()).getChangeMessages().get((Object)psId);
    }

    public void addChangeMessage(ReviewDb db, ChangeUpdate update, ChangeMessage changeMessage) throws OrmException {
        update.setChangeMessage(changeMessage.getMessage());
        db.changeMessages().insert(Collections.singleton(changeMessage));
    }
}

