/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Optional;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupName;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GroupCacheImpl
implements GroupCache {
    private static final Logger log = LoggerFactory.getLogger(GroupCacheImpl.class);
    private static final String BYID_NAME = "groups";
    private static final String BYNAME_NAME = "groups_byname";
    private static final String BYUUID_NAME = "groups_byuuid";
    private final LoadingCache<AccountGroup.Id, Optional<AccountGroup>> byId;
    private final LoadingCache<String, Optional<AccountGroup>> byName;
    private final LoadingCache<String, Optional<AccountGroup>> byUUID;
    private final SchemaFactory<ReviewDb> schema;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(GroupCacheImpl.BYID_NAME, AccountGroup.Id.class, new TypeLiteral<Optional<AccountGroup>>(){}).loader(ByIdLoader.class);
                this.cache(GroupCacheImpl.BYNAME_NAME, String.class, new TypeLiteral<Optional<AccountGroup>>(){}).loader(ByNameLoader.class);
                this.cache(GroupCacheImpl.BYUUID_NAME, String.class, new TypeLiteral<Optional<AccountGroup>>(){}).loader(ByUUIDLoader.class);
                this.bind(GroupCacheImpl.class);
                this.bind(GroupCache.class).to(GroupCacheImpl.class);
            }
        };
    }

    @Inject
    GroupCacheImpl(@Named(value="groups") LoadingCache<AccountGroup.Id, Optional<AccountGroup>> byId, @Named(value="groups_byname") LoadingCache<String, Optional<AccountGroup>> byName, @Named(value="groups_byuuid") LoadingCache<String, Optional<AccountGroup>> byUUID, SchemaFactory<ReviewDb> schema) {
        this.byId = byId;
        this.byName = byName;
        this.byUUID = byUUID;
        this.schema = schema;
    }

    @Override
    public AccountGroup get(AccountGroup.Id groupId) {
        try {
            Optional<AccountGroup> g = this.byId.get(groupId);
            return g.isPresent() ? g.get() : GroupCacheImpl.missing(groupId);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load group " + groupId, e);
            return GroupCacheImpl.missing(groupId);
        }
    }

    @Override
    public void evict(AccountGroup group) {
        if (group.getId() != null) {
            this.byId.invalidate(group.getId());
        }
        if (group.getNameKey() != null) {
            this.byName.invalidate(group.getNameKey().get());
        }
        if (group.getGroupUUID() != null) {
            this.byUUID.invalidate(group.getGroupUUID().get());
        }
    }

    @Override
    public void evictAfterRename(AccountGroup.NameKey oldName, AccountGroup.NameKey newName) {
        if (oldName != null) {
            this.byName.invalidate(oldName.get());
        }
        if (newName != null) {
            this.byName.invalidate(newName.get());
        }
    }

    @Override
    public AccountGroup get(AccountGroup.NameKey name) {
        if (name == null) {
            return null;
        }
        try {
            return this.byName.get(name.get()).orNull();
        }
        catch (ExecutionException e) {
            log.warn(String.format("Cannot lookup group %s by name", name.get()), e);
            return null;
        }
    }

    @Override
    public AccountGroup get(AccountGroup.UUID uuid) {
        if (uuid == null) {
            return null;
        }
        try {
            return this.byUUID.get(uuid.get()).orNull();
        }
        catch (ExecutionException e) {
            log.warn(String.format("Cannot lookup group %s by name", uuid.get()), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<AccountGroup> all() {
        List<AccountGroup> list;
        ReviewDb db = this.schema.open();
        try {
            list = Collections.unmodifiableList(db.accountGroups().all().toList());
        }
        catch (Throwable throwable) {
            try {
                db.close();
                throw throwable;
            }
            catch (OrmException e) {
                log.warn("Cannot list internal groups", e);
                return Collections.emptyList();
            }
        }
        db.close();
        return list;
    }

    @Override
    public void onCreateGroup(AccountGroup.NameKey newGroupName) {
        this.byName.invalidate(newGroupName.get());
    }

    private static AccountGroup missing(AccountGroup.Id key) {
        AccountGroup.NameKey name = new AccountGroup.NameKey("Deleted Group" + key);
        return new AccountGroup(name, key, null);
    }

    static class ByUUIDLoader
    extends CacheLoader<String, Optional<AccountGroup>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        ByUUIDLoader(SchemaFactory<ReviewDb> sf) {
            this.schema = sf;
        }

        @Override
        public Optional<AccountGroup> load(String uuid) throws Exception {
            try (ReviewDb db = this.schema.open();){
                List<AccountGroup> r = db.accountGroups().byUUID(new AccountGroup.UUID(uuid)).toList();
                if (r.size() == 1) {
                    Optional<AccountGroup> optional = Optional.of(r.get(0));
                    return optional;
                }
                if (r.size() == 0) {
                    Optional<AccountGroup> optional = Optional.absent();
                    return optional;
                }
                throw new OrmDuplicateKeyException("Duplicate group UUID " + uuid);
            }
        }
    }

    static class ByNameLoader
    extends CacheLoader<String, Optional<AccountGroup>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        ByNameLoader(SchemaFactory<ReviewDb> sf) {
            this.schema = sf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<AccountGroup> load(String name) throws Exception {
            try (ReviewDb db = this.schema.open();){
                AccountGroup.NameKey key = new AccountGroup.NameKey(name);
                AccountGroupName r = db.accountGroupNames().get(key);
                if (r != null) {
                    Optional<AccountGroup> optional = Optional.fromNullable(db.accountGroups().get(r.getId()));
                    return optional;
                }
                Optional<AccountGroup> optional = Optional.absent();
                return optional;
            }
        }
    }

    static class ByIdLoader
    extends CacheLoader<AccountGroup.Id, Optional<AccountGroup>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        ByIdLoader(SchemaFactory<ReviewDb> sf) {
            this.schema = sf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<AccountGroup> load(AccountGroup.Id key) throws Exception {
            try (ReviewDb db = this.schema.open();){
                Optional<AccountGroup> optional = Optional.fromNullable(db.accountGroups().get(key));
                return optional;
            }
        }
    }
}

