/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.InternalUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupCache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

public class GroupControl {
    private final CurrentUser user;
    private final GroupDescription.Basic group;
    private Boolean isOwner;

    GroupControl(CurrentUser who, GroupDescription.Basic gd) {
        this.user = who;
        this.group = gd;
    }

    public GroupDescription.Basic getGroup() {
        return this.group;
    }

    public CurrentUser getCurrentUser() {
        return this.user;
    }

    public boolean isVisible() {
        AccountGroup accountGroup = GroupDescriptions.toAccountGroup(this.group);
        return accountGroup != null && accountGroup.isVisibleToAll() || this.user instanceof InternalUser || this.user.getEffectiveGroups().contains(this.group.getGroupUUID()) || this.isOwner() || this.user.getCapabilities().canAdministrateServer();
    }

    public boolean isOwner() {
        AccountGroup accountGroup = GroupDescriptions.toAccountGroup(this.group);
        if (accountGroup == null) {
            this.isOwner = false;
        } else if (this.isOwner == null) {
            AccountGroup.UUID ownerUUID = accountGroup.getOwnerGroupUUID();
            this.isOwner = this.getCurrentUser().getEffectiveGroups().contains(ownerUUID) || this.getCurrentUser().getCapabilities().canAdministrateServer();
        }
        return this.isOwner;
    }

    public boolean canAddMember(Account.Id id) {
        return this.isOwner();
    }

    public boolean canRemoveMember(Account.Id id) {
        return this.isOwner();
    }

    public boolean canSeeMember(Account.Id id) {
        if (this.user.isIdentifiedUser() && ((IdentifiedUser)this.user).getAccountId().equals(id)) {
            return true;
        }
        return this.canSeeMembers();
    }

    public boolean canAddGroup(AccountGroup.UUID uuid) {
        return this.isOwner();
    }

    public boolean canRemoveGroup(AccountGroup.UUID uuid) {
        return this.isOwner();
    }

    public boolean canSeeGroup(AccountGroup.UUID uuid) {
        return this.canSeeMembers();
    }

    private boolean canSeeMembers() {
        AccountGroup accountGroup = GroupDescriptions.toAccountGroup(this.group);
        return accountGroup != null && accountGroup.isVisibleToAll() || this.isOwner();
    }

    public static class Factory {
        private final GroupCache groupCache;
        private final Provider<CurrentUser> user;
        private final GroupBackend groupBackend;

        @Inject
        Factory(GroupCache gc, Provider<CurrentUser> cu, GroupBackend gb) {
            this.groupCache = gc;
            this.user = cu;
            this.groupBackend = gb;
        }

        public GroupControl controlFor(AccountGroup.Id groupId) throws NoSuchGroupException {
            AccountGroup group = this.groupCache.get(groupId);
            if (group == null) {
                throw new NoSuchGroupException(groupId);
            }
            return this.controlFor(GroupDescriptions.forAccountGroup(group));
        }

        public GroupControl controlFor(AccountGroup.UUID groupId) throws NoSuchGroupException {
            GroupDescription.Basic group = this.groupBackend.get(groupId);
            if (group == null) {
                throw new NoSuchGroupException(groupId);
            }
            return this.controlFor(group);
        }

        public GroupControl controlFor(AccountGroup group) {
            return this.controlFor(GroupDescriptions.forAccountGroup(group));
        }

        public GroupControl controlFor(GroupDescription.Basic group) {
            return new GroupControl(this.user.get(), group);
        }

        public GroupControl validateFor(AccountGroup.Id groupId) throws NoSuchGroupException {
            GroupControl c = this.controlFor(groupId);
            if (!c.isVisible()) {
                throw new NoSuchGroupException(groupId);
            }
            return c;
        }

        public GroupControl validateFor(AccountGroup.UUID groupUUID) throws NoSuchGroupException {
            GroupControl c = this.controlFor(groupUUID);
            if (!c.isVisible()) {
                throw new NoSuchGroupException(groupUUID);
            }
            return c;
        }
    }

    @Singleton
    public static class GenericFactory {
        private final GroupBackend groupBackend;

        @Inject
        GenericFactory(GroupBackend gb) {
            this.groupBackend = gb;
        }

        public GroupControl controlFor(CurrentUser who, AccountGroup.UUID groupId) throws NoSuchGroupException {
            GroupDescription.Basic group = this.groupBackend.get(groupId);
            if (group == null) {
                throw new NoSuchGroupException(groupId);
            }
            return new GroupControl(who, group);
        }
    }
}

