/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.cache.h2;

import com.google.common.cache.AbstractLoadingCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.google.common.hash.PrimitiveSink;
import com.google.gerrit.server.cache.PersistentCache;
import com.google.gerrit.server.util.TimeUtil;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.Driver;
import org.h2.jdbc.JdbcSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2CacheImpl<K, V>
extends AbstractLoadingCache<K, V>
implements PersistentCache {
    private static final Logger log = LoggerFactory.getLogger(H2CacheImpl.class);
    private final Executor executor;
    private final SqlStore<K, V> store;
    private final TypeLiteral<K> keyType;
    private final Cache<K, ValueHolder<V>> mem;

    H2CacheImpl(Executor executor, SqlStore<K, V> store, TypeLiteral<K> keyType, Cache<K, ValueHolder<V>> mem) {
        this.executor = executor;
        this.store = store;
        this.keyType = keyType;
        this.mem = mem;
    }

    @Override
    public V getIfPresent(Object objKey) {
        if (!this.keyType.getRawType().isInstance(objKey)) {
            return null;
        }
        Object key = objKey;
        ValueHolder<V> h = this.mem.getIfPresent(key);
        if (h != null) {
            return h.value;
        }
        if (this.store.mightContain(key) && (h = this.store.getIfPresent(key)) != null) {
            this.mem.put(key, h);
            return h.value;
        }
        return null;
    }

    @Override
    public V get(K key) throws ExecutionException {
        if (this.mem instanceof LoadingCache) {
            return ((ValueHolder)((LoadingCache)this.mem).get(key)).value;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(final K key, V val) {
        final ValueHolder<V> h = new ValueHolder<V>(val);
        h.created = TimeUtil.nowMs();
        this.mem.put(key, h);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                H2CacheImpl.this.store.put(key, h);
            }
        });
    }

    @Override
    public void invalidate(final Object key) {
        if (this.keyType.getRawType().isInstance(key) && this.store.mightContain(key)) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    H2CacheImpl.this.store.invalidate(key);
                }
            });
        }
        this.mem.invalidate(key);
    }

    @Override
    public void invalidateAll() {
        this.store.invalidateAll();
        this.mem.invalidateAll();
    }

    @Override
    public long size() {
        return this.mem.size();
    }

    @Override
    public CacheStats stats() {
        return this.mem.stats();
    }

    @Override
    public PersistentCache.DiskStats diskStats() {
        return this.store.diskStats();
    }

    void start() {
        this.store.open();
    }

    void stop() {
        for (Map.Entry e : this.mem.asMap().entrySet()) {
            ValueHolder h = (ValueHolder)e.getValue();
            if (h.clean) continue;
            this.store.put(e.getKey(), h);
        }
        this.store.close();
    }

    void prune(final ScheduledExecutorService service) {
        this.store.prune(this.mem);
        Calendar cal = Calendar.getInstance();
        cal.set(11, 1);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, 1);
        long delay = cal.getTimeInMillis() - TimeUtil.nowMs();
        service.schedule(new Runnable(){

            @Override
            public void run() {
                H2CacheImpl.this.prune(service);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    private static class SinkOutputStream
    extends OutputStream {
        private final PrimitiveSink sink;

        SinkOutputStream(PrimitiveSink sink) {
            this.sink = sink;
        }

        @Override
        public void write(int b) {
            this.sink.putByte((byte)b);
        }

        @Override
        public void write(byte[] b, int p, int n) {
            this.sink.putBytes(b, p, n);
        }
    }

    static class SqlHandle {
        private final String url;
        Connection conn;
        PreparedStatement get;
        PreparedStatement put;
        PreparedStatement touch;
        PreparedStatement invalidate;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SqlHandle(String url, KeyType<?> type) throws SQLException {
            this.url = url;
            this.conn = Driver.load().connect(url, null);
            try (Statement stmt = this.conn.createStatement();){
                stmt.execute("CREATE TABLE IF NOT EXISTS data(k " + type.columnType() + " NOT NULL PRIMARY KEY HASH" + ",v OTHER NOT NULL" + ",created TIMESTAMP NOT NULL" + ",accessed TIMESTAMP NOT NULL" + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            this.get = this.closeStatement(this.get);
            this.put = this.closeStatement(this.put);
            this.touch = this.closeStatement(this.touch);
            this.invalidate = this.closeStatement(this.invalidate);
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    log.warn("Cannot close connection to " + this.url, e);
                }
                finally {
                    this.conn = null;
                }
            }
        }

        private PreparedStatement closeStatement(PreparedStatement ps) {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.warn("Cannot close statement for " + this.url, e);
                }
            }
            return null;
        }
    }

    static class SqlStore<K, V> {
        private final String url;
        private final KeyType<K> keyType;
        private final long maxSize;
        private final long expireAfterWrite;
        private final BlockingQueue<SqlHandle> handles;
        private final AtomicLong hitCount = new AtomicLong();
        private final AtomicLong missCount = new AtomicLong();
        private volatile BloomFilter<K> bloomFilter;
        private int estimatedSize;

        SqlStore(String jdbcUrl, TypeLiteral<K> keyType, long maxSize, long expireAfterWrite) {
            this.url = jdbcUrl;
            this.keyType = KeyType.create(keyType);
            this.maxSize = maxSize;
            this.expireAfterWrite = expireAfterWrite;
            int cores = Runtime.getRuntime().availableProcessors();
            int keep = Math.min(cores, 16);
            this.handles = new ArrayBlockingQueue<SqlHandle>(keep);
        }

        synchronized void open() {
            if (this.bloomFilter == null) {
                this.bloomFilter = this.buildBloomFilter();
            }
        }

        void close() {
            SqlHandle h;
            while ((h = (SqlHandle)this.handles.poll()) != null) {
                h.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean mightContain(K key) {
            BloomFilter<K> b = this.bloomFilter;
            if (b == null) {
                SqlStore sqlStore = this;
                synchronized (sqlStore) {
                    b = this.bloomFilter;
                    if (b == null) {
                        b = this.buildBloomFilter();
                        this.bloomFilter = b;
                    }
                }
            }
            return b == null || b.mightContain(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BloomFilter<K> buildBloomFilter() {
            SqlHandle c = null;
            try {
                BloomFilter<K> bloomFilter;
                c = this.acquire();
                Statement s = c.conn.createStatement();
                try {
                    BloomFilter<K> b;
                    block20: {
                        ResultSet r;
                        if (this.estimatedSize <= 0) {
                            r = s.executeQuery("SELECT COUNT(*) FROM data");
                            try {
                                this.estimatedSize = r.next() ? r.getInt(1) : 0;
                            }
                            finally {
                                r.close();
                            }
                        }
                        b = this.newBloomFilter();
                        r = s.executeQuery("SELECT k FROM data");
                        try {
                            while (r.next()) {
                                b.put(this.keyType.get(r, 1));
                            }
                        }
                        catch (JdbcSQLException e) {
                            if (e.getCause() instanceof InvalidClassException) {
                                log.warn("Entries cached for " + this.url + " have an incompatible class and can't be deserialized. " + "Cache is flushed.");
                                this.invalidateAll();
                                break block20;
                            }
                            throw e;
                        }
                        finally {
                            r.close();
                        }
                    }
                    bloomFilter = b;
                }
                catch (Throwable throwable) {
                    try {
                        s.close();
                        throw throwable;
                    }
                    catch (SQLException e) {
                        log.warn("Cannot build BloomFilter for " + this.url, e);
                        c = this.close(c);
                        BloomFilter<K> bloomFilter2 = null;
                        return bloomFilter2;
                    }
                }
                s.close();
                return bloomFilter;
            }
            finally {
                this.release(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ValueHolder<V> getIfPresent(K key) {
            SqlHandle c = null;
            try {
                ResultSet r;
                block14: {
                    block13: {
                        ValueHolder<V> valueHolder;
                        c = this.acquire();
                        if (c.get == null) {
                            c.get = c.conn.prepareStatement("SELECT v, created FROM data WHERE k=?");
                        }
                        this.keyType.set(c.get, 1, key);
                        r = c.get.executeQuery();
                        try {
                            if (r.next()) break block13;
                            this.missCount.incrementAndGet();
                            valueHolder = null;
                        }
                        catch (Throwable throwable) {
                            try {
                                r.close();
                                c.get.clearParameters();
                                throw throwable;
                            }
                            catch (SQLException e) {
                                log.warn("Cannot read cache " + this.url + " for " + key, e);
                                c = this.close(c);
                                ValueHolder<V> valueHolder2 = null;
                                return valueHolder2;
                            }
                        }
                        r.close();
                        c.get.clearParameters();
                        return valueHolder;
                    }
                    Timestamp created = r.getTimestamp(2);
                    if (!this.expired(created)) break block14;
                    this.invalidate(key);
                    this.missCount.incrementAndGet();
                    ValueHolder<V> valueHolder = null;
                    r.close();
                    c.get.clearParameters();
                    return valueHolder;
                }
                Object val = r.getObject(1);
                ValueHolder<Object> h = new ValueHolder<Object>(val);
                h.clean = true;
                this.hitCount.incrementAndGet();
                this.touch(c, key);
                ValueHolder<Object> valueHolder = h;
                r.close();
                c.get.clearParameters();
                return valueHolder;
            }
            finally {
                this.release(c);
            }
        }

        private boolean expired(Timestamp created) {
            if (this.expireAfterWrite == 0L) {
                return false;
            }
            long age = TimeUtil.nowMs() - created.getTime();
            return 1000L * this.expireAfterWrite < age;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void touch(SqlHandle c, K key) throws SQLException {
            if (c.touch == null) {
                c.touch = c.conn.prepareStatement("UPDATE data SET accessed=? WHERE k=?");
            }
            try {
                c.touch.setTimestamp(1, TimeUtil.nowTs());
                this.keyType.set(c.touch, 2, key);
                c.touch.executeUpdate();
            }
            finally {
                c.touch.clearParameters();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(K key, ValueHolder<V> holder) {
            if (holder.clean) {
                return;
            }
            BloomFilter<K> b = this.bloomFilter;
            if (b != null) {
                b.put(key);
                this.bloomFilter = b;
            }
            SqlHandle c = null;
            try {
                c = this.acquire();
                if (c.put == null) {
                    c.put = c.conn.prepareStatement("MERGE INTO data VALUES(?,?,?,?)");
                }
                try {
                    this.keyType.set(c.put, 1, key);
                    c.put.setObject(2, holder.value, 2000);
                    c.put.setTimestamp(3, new Timestamp(holder.created));
                    c.put.setTimestamp(4, TimeUtil.nowTs());
                    c.put.executeUpdate();
                    holder.clean = true;
                }
                finally {
                    c.put.clearParameters();
                }
            }
            catch (SQLException e) {
                log.warn("Cannot put into cache " + this.url, e);
                c = this.close(c);
            }
            finally {
                this.release(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invalidate(K key) {
            SqlHandle c = null;
            try {
                c = this.acquire();
                this.invalidate(c, key);
            }
            catch (SQLException e) {
                log.warn("Cannot invalidate cache " + this.url, e);
                c = this.close(c);
            }
            finally {
                this.release(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invalidate(SqlHandle c, K key) throws SQLException {
            if (c.invalidate == null) {
                c.invalidate = c.conn.prepareStatement("DELETE FROM data WHERE k=?");
            }
            try {
                this.keyType.set(c.invalidate, 1, key);
                c.invalidate.executeUpdate();
            }
            finally {
                c.invalidate.clearParameters();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invalidateAll() {
            SqlHandle c = null;
            try {
                c = this.acquire();
                try (Statement s = c.conn.createStatement();){
                    s.executeUpdate("DELETE FROM data");
                }
                this.bloomFilter = this.newBloomFilter();
            }
            catch (SQLException e) {
                log.warn("Cannot invalidate cache " + this.url, e);
                c = this.close(c);
            }
            finally {
                this.release(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void prune(Cache<K, ?> mem) {
            SqlHandle c = null;
            try {
                c = this.acquire();
                try (Statement s = c.conn.createStatement();){
                    long used = 0L;
                    try (ResultSet r = s.executeQuery("SELECT SUM(OCTET_LENGTH(k) + OCTET_LENGTH(v)) FROM data");){
                        used = r.next() ? r.getLong(1) : 0L;
                    }
                    if (used <= this.maxSize) {
                        return;
                    }
                    r = s.executeQuery("SELECT k,OCTET_LENGTH(k) + OCTET_LENGTH(v),created FROM data ORDER BY accessed");
                    try {
                        while (this.maxSize < used && r.next()) {
                            K key = this.keyType.get(r, 1);
                            Timestamp created = r.getTimestamp(3);
                            if (mem.getIfPresent(key) != null && !this.expired(created)) {
                                this.touch(c, key);
                                continue;
                            }
                            this.invalidate(c, key);
                            used -= r.getLong(2);
                        }
                    }
                    finally {
                        r.close();
                    }
                }
            }
            catch (SQLException e) {
                log.warn("Cannot prune cache " + this.url, e);
                c = this.close(c);
            }
            finally {
                this.release(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PersistentCache.DiskStats diskStats() {
            long size = 0L;
            long space = 0L;
            SqlHandle c = null;
            try {
                c = this.acquire();
                try (Statement s = c.conn.createStatement();
                     ResultSet r = s.executeQuery("SELECT COUNT(*),SUM(OCTET_LENGTH(k) + OCTET_LENGTH(v)) FROM data");){
                    if (r.next()) {
                        size = r.getLong(1);
                        space = r.getLong(2);
                    }
                }
            }
            catch (SQLException e) {
                log.warn("Cannot get DiskStats for " + this.url, e);
                c = this.close(c);
            }
            finally {
                this.release(c);
            }
            return new PersistentCache.DiskStats(size, space, this.hitCount.get(), this.missCount.get());
        }

        private SqlHandle acquire() throws SQLException {
            SqlHandle h = (SqlHandle)this.handles.poll();
            return h != null ? h : new SqlHandle(this.url, this.keyType);
        }

        private void release(SqlHandle h) {
            if (h != null && !this.handles.offer(h)) {
                h.close();
            }
        }

        private SqlHandle close(SqlHandle h) {
            if (h != null) {
                h.close();
            }
            return null;
        }

        private BloomFilter<K> newBloomFilter() {
            int cnt = Math.max(65536, 2 * this.estimatedSize);
            return BloomFilter.create(this.keyType.funnel(), cnt);
        }
    }

    private static class KeyType<K> {
        static final KeyType<?> OTHER = new KeyType();
        static final KeyType<String> STRING = new KeyType<String>(){

            @Override
            String columnType() {
                return "VARCHAR(4096)";
            }

            @Override
            String get(ResultSet rs, int col) throws SQLException {
                return rs.getString(col);
            }

            @Override
            void set(PreparedStatement ps, int col, String value) throws SQLException {
                ps.setString(col, value);
            }

            @Override
            Funnel<String> funnel() {
                Funnel<CharSequence> s = Funnels.unencodedCharsFunnel();
                return s;
            }
        };

        private KeyType() {
        }

        String columnType() {
            return "OTHER";
        }

        K get(ResultSet rs, int col) throws SQLException {
            return (K)rs.getObject(col);
        }

        void set(PreparedStatement ps, int col, K value) throws SQLException {
            ps.setObject(col, value, 2000);
        }

        Funnel<K> funnel() {
            return new Funnel<K>(){
                private static final long serialVersionUID = 1L;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void funnel(K from, PrimitiveSink into) {
                    try (ObjectOutputStream ser = new ObjectOutputStream(new SinkOutputStream(into));){
                        ser.writeObject(from);
                        ser.flush();
                    }
                    catch (IOException err) {
                        throw new RuntimeException("Cannot hash as Serializable", err);
                    }
                }
            };
        }

        static <K> KeyType<K> create(TypeLiteral<K> type) {
            if (type.getRawType() == String.class) {
                return STRING;
            }
            return OTHER;
        }
    }

    static class Loader<K, V>
    extends CacheLoader<K, ValueHolder<V>> {
        private final Executor executor;
        private final SqlStore<K, V> store;
        private final CacheLoader<K, V> loader;

        Loader(Executor executor, SqlStore<K, V> store, CacheLoader<K, V> loader) {
            this.executor = executor;
            this.store = store;
            this.loader = loader;
        }

        @Override
        public ValueHolder<V> load(final K key) throws Exception {
            ValueHolder<V> h;
            if (this.store.mightContain(key) && (h = this.store.getIfPresent(key)) != null) {
                return h;
            }
            h = new ValueHolder<V>(this.loader.load(key));
            h.created = TimeUtil.nowMs();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Loader.this.store.put(key, h);
                }
            });
            return h;
        }
    }

    static class ValueHolder<V> {
        final V value;
        long created;
        volatile boolean clean;

        ValueHolder(V value) {
            this.value = value;
        }
    }
}

