/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.DraftResource;
import com.google.gerrit.server.change.ListDrafts;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
class Drafts
implements ChildCollection<RevisionResource, DraftResource> {
    private final DynamicMap<RestView<DraftResource>> views;
    private final Provider<CurrentUser> user;
    private final ListDrafts list;
    private final Provider<ReviewDb> dbProvider;

    @Inject
    Drafts(DynamicMap<RestView<DraftResource>> views, Provider<CurrentUser> user, ListDrafts list, Provider<ReviewDb> dbProvider) {
        this.views = views;
        this.user = user;
        this.list = list;
        this.dbProvider = dbProvider;
    }

    @Override
    public DynamicMap<RestView<DraftResource>> views() {
        return this.views;
    }

    @Override
    public RestView<RevisionResource> list() throws AuthException {
        this.checkIdentifiedUser();
        return this.list;
    }

    @Override
    public DraftResource parse(RevisionResource rev, IdString id) throws ResourceNotFoundException, OrmException, AuthException {
        this.checkIdentifiedUser();
        String uuid = id.get();
        for (PatchLineComment c : this.dbProvider.get().patchComments().draftByPatchSetAuthor(rev.getPatchSet().getId(), rev.getAccountId())) {
            if (!uuid.equals(c.getKey().get())) continue;
            return new DraftResource(rev, c);
        }
        throw new ResourceNotFoundException(id);
    }

    private void checkIdentifiedUser() throws AuthException {
        if (!this.user.get().isIdentifiedUser()) {
            throw new AuthException("drafts only available to authenticated users");
        }
    }
}

