/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.RemotePeer;
import com.google.gerrit.server.config.GerritRequestModule;
import com.google.gerrit.server.config.RequestScopedReviewDbProvider;
import com.google.gerrit.server.git.MergeOp;
import com.google.gerrit.server.git.MergeQueue;
import com.google.gerrit.server.git.PerThreadRequestScope;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.ssh.SshInfo;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gerrit.server.util.TimeUtil;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.servlet.RequestScoped;
import com.jcraft.jsch.HostKey;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ChangeMergeQueue
implements MergeQueue {
    private static final Logger log = LoggerFactory.getLogger(ChangeMergeQueue.class);
    private final Map<Branch.NameKey, MergeEntry> active = new HashMap<Branch.NameKey, MergeEntry>();
    private final Map<Branch.NameKey, RecheckJob> recheck = new HashMap<Branch.NameKey, RecheckJob>();
    private final WorkQueue workQueue;
    private final Provider<MergeOp.Factory> bgFactory;
    private final PerThreadRequestScope.Scoper threadScoper;

    @Inject
    ChangeMergeQueue(WorkQueue wq, Injector parent) {
        this.workQueue = wq;
        Injector child = parent.createChildInjector(new AbstractModule(){

            @Override
            protected void configure() {
                this.bindScope(RequestScoped.class, PerThreadRequestScope.REQUEST);
                this.bind(RequestScopePropagator.class).to(PerThreadRequestScope.Propagator.class);
                this.bind(PerThreadRequestScope.Propagator.class);
                this.install(new GerritRequestModule());
                this.bind(SocketAddress.class).annotatedWith(RemotePeer.class).toProvider(new Provider<SocketAddress>(){

                    @Override
                    public SocketAddress get() {
                        throw new OutOfScopeException("No remote peer on merge thread");
                    }
                });
                this.bind(SshInfo.class).toInstance(new SshInfo(){

                    @Override
                    public List<HostKey> getHostKeys() {
                        return Collections.emptyList();
                    }
                });
            }

            @Provides
            public PerThreadRequestScope.Scoper provideScoper(final PerThreadRequestScope.Propagator propagator, final Provider<RequestScopedReviewDbProvider> dbProvider) {
                final RequestContext requestContext = new RequestContext(){

                    @Override
                    public CurrentUser getCurrentUser() {
                        throw new OutOfScopeException("No user on merge thread");
                    }

                    @Override
                    public Provider<ReviewDb> getReviewDbProvider() {
                        return (Provider)dbProvider.get();
                    }
                };
                return new PerThreadRequestScope.Scoper(){

                    @Override
                    public <T> Callable<T> scope(Callable<T> callable) {
                        return propagator.scope(requestContext, callable);
                    }
                };
            }
        });
        this.bgFactory = child.getProvider(MergeOp.Factory.class);
        this.threadScoper = child.getInstance(PerThreadRequestScope.Scoper.class);
    }

    @Override
    public void merge(Branch.NameKey branch) {
        if (this.start(branch)) {
            this.mergeImpl(branch);
        }
    }

    private synchronized boolean start(Branch.NameKey branch) {
        MergeEntry e = this.active.get(branch);
        if (e == null) {
            this.active.put(branch, new MergeEntry(branch));
            return true;
        }
        e.needMerge = true;
        return false;
    }

    @Override
    public synchronized void schedule(Branch.NameKey branch) {
        MergeEntry e = this.active.get(branch);
        if (e == null) {
            e = new MergeEntry(branch);
            this.active.put(branch, e);
            e.needMerge = true;
            this.scheduleJob(e);
        } else {
            e.needMerge = true;
        }
    }

    @Override
    public synchronized void recheckAfter(Branch.NameKey branch, long delay, TimeUnit delayUnit) {
        long now = TimeUtil.nowMs();
        long at = now + TimeUnit.MILLISECONDS.convert(delay, delayUnit);
        RecheckJob e = this.recheck.get(branch);
        if (e == null) {
            e = new RecheckJob(branch);
            this.workQueue.getDefaultQueue().schedule(e, now - at, TimeUnit.MILLISECONDS);
            this.recheck.put(branch, e);
        }
        e.recheckAt = Math.max(at, e.recheckAt);
    }

    private synchronized void finish(Branch.NameKey branch) {
        MergeEntry e = this.active.get(branch);
        if (e == null) {
            return;
        }
        if (!e.needMerge) {
            this.active.remove(branch);
            return;
        }
        this.scheduleJob(e);
    }

    private void scheduleJob(MergeEntry e) {
        if (!e.jobScheduled) {
            e.jobScheduled = true;
            this.workQueue.getDefaultQueue().schedule(e, 0L, TimeUnit.SECONDS);
        }
    }

    private synchronized void unschedule(MergeEntry e) {
        e.jobScheduled = false;
        e.needMerge = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeImpl(final Branch.NameKey branch) {
        try {
            this.threadScoper.scope(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ((MergeOp.Factory)ChangeMergeQueue.this.bgFactory.get()).create(branch).merge();
                    return null;
                }
            }).call();
        }
        catch (Throwable e) {
            log.error("Merge attempt for " + branch + " failed", e);
        }
        finally {
            this.finish(branch);
        }
    }

    private synchronized void recheck(RecheckJob e) {
        long remainingDelay = e.recheckAt - TimeUtil.nowMs();
        if (TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS) < remainingDelay) {
            this.workQueue.getDefaultQueue().schedule(e, remainingDelay, TimeUnit.MILLISECONDS);
        } else {
            this.schedule(e.dest);
        }
    }

    private class RecheckJob
    implements Runnable {
        final Branch.NameKey dest;
        long recheckAt;

        RecheckJob(Branch.NameKey d) {
            this.dest = d;
        }

        @Override
        public void run() {
            ChangeMergeQueue.this.recheck(this);
        }

        public String toString() {
            Project.NameKey project = this.dest.getParentKey();
            return "recheck " + project.get() + " " + this.dest.getShortName();
        }
    }

    private class MergeEntry
    implements Runnable {
        final Branch.NameKey dest;
        boolean needMerge;
        boolean jobScheduled;

        MergeEntry(Branch.NameKey d) {
            this.dest = d;
        }

        @Override
        public void run() {
            ChangeMergeQueue.this.unschedule(this);
            ChangeMergeQueue.this.mergeImpl(this.dest);
        }

        public String toString() {
            Project.NameKey project = this.dest.getParentKey();
            return "submit " + project.get() + " " + this.dest.getShortName();
        }
    }
}

