/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountProjectWatch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.StarredChange;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.mail.EmailArguments;
import com.google.gerrit.server.mail.NotificationEmail;
import com.google.gerrit.server.mail.ProjectWatch;
import com.google.gerrit.server.mail.RecipientType;
import com.google.gerrit.server.notedb.ReviewerState;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListEntry;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChangeEmail
extends NotificationEmail {
    private static final Logger log = LoggerFactory.getLogger(ChangeEmail.class);
    protected final Change change;
    protected final ChangeData changeData;
    protected PatchSet patchSet;
    protected PatchSetInfo patchSetInfo;
    protected ChangeMessage changeMessage;
    protected ProjectState projectState;
    protected Set<Account.Id> authors;
    protected boolean emailOnlyAuthors;

    protected ChangeEmail(EmailArguments ea, Change c, String mc) {
        super(ea, mc, c.getProject(), c.getDest());
        this.change = c;
        this.changeData = ea.changeDataFactory.create(ea.db.get(), c);
        this.emailOnlyAuthors = false;
    }

    @Override
    public void setFrom(Account.Id id) {
        super.setFrom(id);
        IdentifiedUser user = this.args.identifiedUserFactory.create(id);
        this.emailOnlyAuthors = !user.getCapabilities().canEmailReviewers();
    }

    public void setPatchSet(PatchSet ps) {
        this.patchSet = ps;
    }

    public void setPatchSet(PatchSet ps, PatchSetInfo psi) {
        this.patchSet = ps;
        this.patchSetInfo = psi;
    }

    public void setChangeMessage(ChangeMessage cm) {
        this.changeMessage = cm;
    }

    @Override
    protected void format() throws EmailException {
        this.formatChange();
        this.appendText(this.velocifyFile("ChangeFooter.vm"));
        try {
            TreeSet<String> names = new TreeSet<String>();
            for (Account.Id who : this.changeData.reviewers().values()) {
                names.add(this.getNameEmailFor(who));
            }
            for (String name : names) {
                this.appendText("Gerrit-Reviewer: " + name + "\n");
            }
        }
        catch (OrmException ormException) {
            // empty catch block
        }
        this.formatFooter();
    }

    protected abstract void formatChange() throws EmailException;

    protected void formatFooter() throws EmailException {
    }

    @Override
    protected void init() throws EmailException {
        this.projectState = this.args.projectCache != null ? this.args.projectCache.get(this.change.getProject()) : null;
        if (this.patchSet == null) {
            try {
                this.patchSet = this.args.db.get().patchSets().get(this.change.currentPatchSetId());
            }
            catch (OrmException err) {
                this.patchSet = null;
            }
        }
        if (this.patchSet != null && this.patchSetInfo == null) {
            try {
                this.patchSetInfo = this.args.patchSetInfoFactory.get(this.args.db.get(), this.patchSet.getId());
            }
            catch (PatchSetInfoNotAvailableException err) {
                this.patchSetInfo = null;
            }
        }
        this.authors = this.getAuthors();
        super.init();
        if (this.changeMessage != null && this.changeMessage.getWrittenOn() != null) {
            this.setHeader("Date", new Date(this.changeMessage.getWrittenOn().getTime()));
        }
        this.setChangeSubjectHeader();
        this.setHeader("X-Gerrit-Change-Id", "" + this.change.getKey().get());
        this.setChangeUrlHeader();
        this.setCommitIdHeader();
    }

    private void setChangeUrlHeader() {
        String u = this.getChangeUrl();
        if (u != null) {
            this.setHeader("X-Gerrit-ChangeURL", "<" + u + ">");
        }
    }

    private void setCommitIdHeader() {
        if (this.patchSet != null && this.patchSet.getRevision() != null && this.patchSet.getRevision().get() != null && this.patchSet.getRevision().get().length() > 0) {
            this.setHeader("X-Gerrit-Commit", this.patchSet.getRevision().get());
        }
    }

    private void setChangeSubjectHeader() throws EmailException {
        this.setHeader("Subject", this.velocifyFile("ChangeSubject.vm"));
    }

    public String getChangeUrl() {
        if (this.getGerritUrl() != null) {
            StringBuilder r = new StringBuilder();
            r.append(this.getGerritUrl());
            r.append(this.change.getChangeId());
            return r.toString();
        }
        return null;
    }

    public String getChangeMessageThreadId() throws EmailException {
        return this.velocify("<gerrit.${change.createdOn.time}.$change.key.get()@$email.gerritHost>");
    }

    protected void formatCoverLetter() {
        String cover = this.getCoverLetter();
        if (!"".equals(cover)) {
            this.appendText(cover);
            this.appendText("\n\n");
        }
    }

    public String getCoverLetter() {
        String txt;
        if (this.changeMessage != null && (txt = this.changeMessage.getMessage()) != null) {
            return txt.trim();
        }
        return "";
    }

    protected void formatChangeDetail() {
        this.appendText(this.getChangeDetail());
    }

    public String getChangeDetail() {
        try {
            StringBuilder detail = new StringBuilder();
            if (this.patchSetInfo != null) {
                detail.append(this.patchSetInfo.getMessage().trim()).append("\n");
            } else {
                detail.append(this.change.getSubject().trim()).append("\n");
            }
            if (this.patchSet != null) {
                detail.append("---\n");
                PatchList patchList = this.getPatchList();
                for (PatchListEntry p : patchList.getPatches()) {
                    if ("/COMMIT_MSG".equals(p.getNewName())) continue;
                    detail.append(p.getChangeType().getCode()).append(" ").append(p.getNewName()).append("\n");
                }
                detail.append(MessageFormat.format("{0,choice,0#0 files|1#1 file|1<{0} files} changed, {1,choice,0#0 insertions|1#1 insertion|1<{1} insertions}(+), {2,choice,0#0 deletions|1#1 deletion|1<{2} deletions}(-)\n", patchList.getPatches().size() - 1, patchList.getInsertions(), patchList.getDeletions()));
                detail.append("\n");
            }
            return detail.toString();
        }
        catch (Exception err) {
            log.warn("Cannot format change detail", err);
            return "";
        }
    }

    protected PatchList getPatchList() throws PatchListNotAvailableException {
        if (this.patchSet != null) {
            return this.args.patchListCache.get(this.change, this.patchSet);
        }
        throw new PatchListNotAvailableException("no patchSet specified");
    }

    protected ProjectState getProjectState() {
        return this.projectState;
    }

    protected Set<AccountGroup.UUID> getProjectOwners() {
        ProjectState r = this.args.projectCache.get(this.change.getProject());
        return r != null ? r.getOwners() : Collections.emptySet();
    }

    protected void rcptToAuthors(RecipientType rt) {
        for (Account.Id id : this.authors) {
            this.add(rt, id);
        }
    }

    protected void bccStarredBy() {
        try {
            for (StarredChange w : this.args.db.get().starredChanges().byChange(this.change.getId())) {
                super.add(RecipientType.BCC, w.getAccountId());
            }
        }
        catch (OrmException err) {
            log.warn("Cannot BCC users that starred updated change", err);
        }
    }

    @Override
    protected final ProjectWatch.Watchers getWatchers(AccountProjectWatch.NotifyType type) throws OrmException {
        ProjectWatch watch = new ProjectWatch(this.args, this.project, this.projectState, this.changeData);
        return watch.getWatchers(type);
    }

    protected void ccAllApprovals() {
        try {
            for (Account.Id id : this.changeData.reviewers().values()) {
                this.add(RecipientType.CC, id);
            }
        }
        catch (OrmException err) {
            log.warn("Cannot CC users that reviewed updated change", err);
        }
    }

    protected void ccExistingReviewers() {
        try {
            for (Account.Id id : this.changeData.reviewers().get(ReviewerState.REVIEWER)) {
                this.add(RecipientType.CC, id);
            }
        }
        catch (OrmException err) {
            log.warn("Cannot CC users that commented on updated change", err);
        }
    }

    @Override
    protected void add(RecipientType rt, Account.Id to) {
        if (!this.emailOnlyAuthors || this.authors.contains(to)) {
            super.add(rt, to);
        }
    }

    @Override
    protected boolean isVisibleTo(Account.Id to) throws OrmException {
        return this.projectState == null || this.projectState.controlFor(this.args.identifiedUserFactory.create(to)).controlFor(this.change).isVisible(this.args.db.get());
    }

    protected Set<Account.Id> getAuthors() {
        HashSet<Account.Id> authors = new HashSet<Account.Id>();
        authors.add(this.change.getOwner());
        if (this.patchSet != null) {
            authors.add(this.patchSet.getUploader());
        }
        if (this.patchSetInfo != null) {
            if (this.patchSetInfo.getAuthor().getAccount() != null) {
                authors.add(this.patchSetInfo.getAuthor().getAccount());
            }
            if (this.patchSetInfo.getCommitter().getAccount() != null) {
                authors.add(this.patchSetInfo.getCommitter().getAccount());
            }
        }
        return authors;
    }

    @Override
    protected void setupVelocityContext() {
        super.setupVelocityContext();
        this.velocityContext.put("change", this.change);
        this.velocityContext.put("changeId", this.change.getKey());
        this.velocityContext.put("coverLetter", this.getCoverLetter());
        this.velocityContext.put("fromName", this.getNameFor(this.fromId));
        this.velocityContext.put("patchSet", this.patchSet);
        this.velocityContext.put("patchSetInfo", this.patchSetInfo);
    }

    public boolean getIncludeDiff() {
        return this.args.settings.includeDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUnifiedDiff() {
        Repository git;
        PatchList patchList;
        try {
            patchList = this.getPatchList();
            if (patchList.getOldId() == null) {
                return "[Octopus merge; cannot be formatted as a diff.]\n";
            }
        }
        catch (PatchListNotAvailableException e) {
            log.error("Cannot format patch", e);
            return "";
        }
        TemporaryBuffer.Heap buf = new TemporaryBuffer.Heap(this.args.settings.maximumDiffSize);
        DiffFormatter fmt = new DiffFormatter(buf);
        try {
            git = this.args.server.openRepository(this.change.getProject());
        }
        catch (IOException e) {
            log.error("Cannot open repository to format patch", e);
            return "";
        }
        try {
            fmt.setRepository(git);
            fmt.setDetectRenames(true);
            fmt.format(patchList.getOldId(), patchList.getNewId());
            String e = RawParseUtils.decode(buf.toByteArray());
            return e;
        }
        catch (IOException e) {
            if (JGitText.get().inMemoryBufferLimitExceeded.equals(e.getMessage())) {
                String string = "";
                return string;
            }
            log.error("Cannot format patch", e);
            String string = "";
            return string;
        }
        finally {
            fmt.release();
            git.close();
        }
    }
}

