/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.patch.IntraLineDiff;
import com.google.gerrit.server.patch.IntraLineDiffKey;
import com.google.gerrit.server.patch.IntraLineLoader;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.lib.Config;

@Singleton
public class IntraLineWorkerPool {
    private final BlockingQueue<Worker> workerPool;

    @Inject
    public IntraLineWorkerPool(@GerritServerConfig Config cfg) {
        int workers = cfg.getInt("cache", "diff_intraline", "maxIdleWorkers", Runtime.getRuntime().availableProcessors() * 3 / 2);
        this.workerPool = new ArrayBlockingQueue<Worker>(workers, true);
    }

    Worker acquire() {
        Worker w = (Worker)this.workerPool.poll();
        if (w == null) {
            w = new Worker();
            w.start();
        }
        return w;
    }

    void release(Worker w) {
        if (!this.workerPool.offer(w)) {
            w.shutdownGracefully();
        }
    }

    static class Worker
    extends Thread {
        private static final AtomicInteger count = new AtomicInteger(1);
        private final ArrayBlockingQueue<Input> input = new ArrayBlockingQueue(1);
        private final ArrayBlockingQueue<Result> result = new ArrayBlockingQueue(1);

        Worker() {
            this.setName("IntraLineDiff-" + count.getAndIncrement());
            this.setDaemon(true);
        }

        Result computeWithTimeout(IntraLineDiffKey key, long timeoutMillis) throws Exception {
            if (!this.input.offer(new Input(key))) {
                IntraLineLoader.log.error("Cannot enqueue task to thread " + this.getName());
                return Result.TIMEOUT;
            }
            Result r = this.result.poll(timeoutMillis, TimeUnit.MILLISECONDS);
            if (r != null) {
                return r;
            }
            IntraLineLoader.log.warn(timeoutMillis + " ms timeout reached for IntraLineDiff" + " in project " + key.getProject().get() + " on commit " + key.getCommit().name() + " for path " + key.getPath() + " comparing " + key.getBlobA().name() + ".." + key.getBlobB().name() + ".  Killing " + this.getName());
            this.forcefullyKillThreadInAnUglyWay();
            return Result.TIMEOUT;
        }

        private void forcefullyKillThreadInAnUglyWay() {
            try {
                this.stop();
            }
            catch (Throwable error) {
                IntraLineLoader.log.error("Cannot stop runaway thread " + this.getName(), error);
            }
        }

        private void shutdownGracefully() {
            if (!this.input.offer(Input.END_THREAD)) {
                IntraLineLoader.log.error("Cannot gracefully stop thread " + this.getName());
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Result r;
                    Input in;
                    try {
                        in = this.input.take();
                    }
                    catch (InterruptedException e) {
                        IntraLineLoader.log.error("Unexpected interrupt on " + this.getName());
                        continue;
                    }
                    if (in == Input.END_THREAD) {
                        return;
                    }
                    try {
                        r = new Result(IntraLineLoader.compute(in.key));
                    }
                    catch (Exception error) {
                        r = new Result(error);
                    }
                    if (this.result.offer(r)) continue;
                    IntraLineLoader.log.error("Cannot return result from " + this.getName());
                }
            }
            catch (ThreadDeath threadDeath) {
                return;
            }
        }

        static class Result {
            static final Result TIMEOUT = new Result((IntraLineDiff)null);
            final IntraLineDiff diff;
            final Exception error;

            Result(IntraLineDiff diff) {
                this.diff = diff;
                this.error = null;
            }

            Result(Exception error) {
                this.diff = null;
                this.error = error;
            }
        }

        private static class Input {
            static final Input END_THREAD = new Input(null);
            final IntraLineDiffKey key;

            Input(IntraLineDiffKey key) {
                this.key = key;
            }
        }
    }

    public static class Module
    extends AbstractModule {
        @Override
        protected void configure() {
            this.bind(IntraLineWorkerPool.class);
        }
    }
}

