/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.common.GitPerson;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.BranchResource;
import com.google.inject.Inject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.kohsuke.args4j.Option;

public class GetReflog
implements RestReadView<BranchResource> {
    private final GitRepositoryManager repoManager;
    private int limit;
    private Timestamp from;
    private Timestamp to;

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="maximum number of reflog entries to list")
    public GetReflog setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Option(name="--from", metaVar="TIMESTAMP", usage="timestamp from which the reflog entries should be listed (UTC, format: yyyyMMdd_HHmm)")
    public GetReflog setFrom(Timestamp from) {
        this.from = from;
        return this;
    }

    @Option(name="--to", metaVar="TIMESTAMP", usage="timestamp until which the reflog entries should be listed (UTC, format: yyyyMMdd_HHmm)")
    public GetReflog setTo(Timestamp to) {
        this.to = to;
        return this;
    }

    @Inject
    public GetReflog(GitRepositoryManager repoManager) {
        this.repoManager = repoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReflogEntryInfo> apply(BranchResource rsrc) throws AuthException, ResourceNotFoundException, RepositoryNotFoundException, IOException {
        if (!rsrc.getControl().isOwner()) {
            throw new AuthException("no project owner");
        }
        try (Repository repo = this.repoManager.openRepository(rsrc.getNameKey());){
            List<Object> entries;
            ReflogReader r = repo.getReflogReader(rsrc.getRef());
            if (r == null) {
                throw new ResourceNotFoundException(rsrc.getRef());
            }
            if (this.from == null && this.to == null) {
                entries = this.limit > 0 ? r.getReverseEntries(this.limit) : r.getReverseEntries();
            } else {
                entries = this.limit > 0 ? new ArrayList(this.limit) : new ArrayList();
                for (ReflogEntry e : r.getReverseEntries()) {
                    Timestamp timestamp = new Timestamp(e.getWho().getWhen().getTime());
                    if ((this.from == null || this.from.before(timestamp)) && (this.to == null || this.to.after(timestamp))) {
                        entries.add(e);
                    }
                    if (this.limit <= 0 || entries.size() < this.limit) continue;
                    break;
                }
            }
            List<ReflogEntryInfo> list = Lists.transform(entries, new Function<ReflogEntry, ReflogEntryInfo>(){

                @Override
                public ReflogEntryInfo apply(ReflogEntry e) {
                    return new ReflogEntryInfo(e);
                }
            });
            return list;
        }
    }

    public static class ReflogEntryInfo {
        public String oldId;
        public String newId;
        public GitPerson who;
        public String comment;

        public ReflogEntryInfo(ReflogEntry e) {
            this.oldId = e.getOldId().getName();
            this.newId = e.getNewId().getName();
            PersonIdent ident = e.getWho();
            this.who = new GitPerson();
            this.who.name = ident.getName();
            this.who.email = ident.getEmailAddress();
            this.who.date = new Timestamp(ident.getWhen().getTime());
            this.who.tz = ident.getTimeZoneOffset();
            this.comment = e.getComment();
        }
    }
}

