/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.collect.ImmutableMap;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_81;
import com.google.gwtorm.jdbc.JdbcExecutor;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.schema.sql.DialectMySQL;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;

public class Schema_82
extends SchemaVersion {
    private Map<String, String> tables = ImmutableMap.of("account_group_includes_by_uuid", "account_group_by_id", "account_group_includes_by_uuid_audit", "account_group_by_id_aud");
    private Map<String, Index> indexes = ImmutableMap.of("account_project_watches_byProject", new Index("account_project_watches", "account_project_watches_byP"), "patch_set_approvals_closedByUser", new Index("patch_set_approvals", "patch_set_approvals_closedByU"), "submodule_subscription_access_bySubscription", new Index("submodule_subscriptions", "submodule_subscr_acc_byS"));

    @Inject
    Schema_82(Provider<Schema_81> prior) {
        super(prior);
    }

    @Override
    protected void preUpdateSchema(ReviewDb db) throws OrmException, SQLException {
        JdbcSchema s = (JdbcSchema)((Object)db);
        JdbcExecutor e = new JdbcExecutor(s);
        this.renameTables(db, s, e);
        this.renameColumn(db, s, e);
        this.renameIndexes(db);
    }

    private void renameTables(ReviewDb db, JdbcSchema s, JdbcExecutor e) throws OrmException, SQLException {
        SqlDialect dialect = ((JdbcSchema)((Object)db)).getDialect();
        Set<String> existingTables = dialect.listTables(s.getConnection());
        for (Map.Entry<String, String> entry : this.tables.entrySet()) {
            if (!existingTables.contains(entry.getKey()) || existingTables.contains(entry.getValue())) continue;
            s.renameTable(e, entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameColumn(ReviewDb db, JdbcSchema s, JdbcExecutor e) throws SQLException, OrmException {
        SqlDialect dialect = ((JdbcSchema)((Object)db)).getDialect();
        Set<String> existingColumns = dialect.listColumns(s.getConnection(), "accounts");
        if (!existingColumns.contains("show_username_in_review_category")) {
            return;
        }
        if (existingColumns.contains("show_user_in_review")) {
            return;
        }
        s.renameColumn(e, "accounts", "show_username_in_review_category", "show_user_in_review");
        if (dialect instanceof DialectMySQL) {
            try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();){
                this.addCheckConstraint(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameIndexes(ReviewDb db) throws SQLException {
        SqlDialect dialect = ((JdbcSchema)((Object)db)).getDialect();
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();){
            if (dialect instanceof DialectMySQL) {
                for (Map.Entry<String, Index> entry : this.indexes.entrySet()) {
                    stmt.executeUpdate("DROP INDEX " + entry.getKey() + " ON " + entry.getValue().table);
                }
                stmt.executeUpdate("CREATE INDEX account_project_watches_byP ON account_project_watches (project_name)");
                stmt.executeUpdate("CREATE INDEX patch_set_approvals_closedByU ON patch_set_approvals (change_open, account_id, change_sort_key)");
                stmt.executeUpdate("CREATE INDEX submodule_subscr_acc_bys ON submodule_subscriptions (submodule_project_name, submodule_branch_name)");
            } else {
                for (Map.Entry<String, Index> entry : this.indexes.entrySet()) {
                    stmt.executeUpdate("ALTER INDEX " + entry.getKey() + " RENAME TO " + entry.getValue().index);
                }
            }
        }
    }

    private void addCheckConstraint(Statement stmt) throws SQLException {
        stmt.executeUpdate("ALTER TABLE accounts ADD CONSTRAINT show_user_in_review_check CHECK (show_user_in_review IN('Y', 'N'))");
    }

    static class Index {
        String table;
        String index;

        Index(String tableName, String indexName) {
            this.table = tableName;
            this.index = indexName;
        }
    }
}

