/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountInfo;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupDetailFactory;
import com.google.gerrit.server.group.ListMembers;
import com.google.gerrit.server.ioutil.ColumnFormatter;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gwtorm.server.OrmException;
import java.io.PrintWriter;
import java.util.List;
import javax.inject.Inject;
import org.apache.sshd.server.Environment;
import org.kohsuke.args4j.Argument;

@CommandMetaData(name="ls-members", description="List the members of a given group", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
public class ListMembersCommand
extends BaseCommand {
    @Inject
    ListMembersCommandImpl impl;

    @Override
    public void start(Environment env) {
        this.startThread(new BaseCommand.CommandRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws Exception {
                ListMembersCommand.this.parseCommandLine(ListMembersCommand.this.impl);
                PrintWriter stdout = ListMembersCommand.toPrintWriter(ListMembersCommand.this.out);
                try {
                    ListMembersCommand.this.impl.display(stdout);
                }
                finally {
                    stdout.flush();
                }
            }
        });
    }

    private static class ListMembersCommandImpl
    extends ListMembers {
        @Argument(required=true, usage="the name of the group", metaVar="GROUPNAME")
        private String name;
        private final GroupCache groupCache;

        @Inject
        protected ListMembersCommandImpl(GroupCache groupCache, GroupDetailFactory.Factory groupDetailFactory, AccountInfo.Loader.Factory accountLoaderFactory, AccountCache accountCache) {
            super(groupCache, groupDetailFactory, accountLoaderFactory);
            this.groupCache = groupCache;
        }

        void display(PrintWriter writer) throws BaseCommand.UnloggedFailure, OrmException {
            AccountGroup group = this.groupCache.get(new AccountGroup.NameKey(this.name));
            String errorText = "Group not found or not visible\n";
            if (group == null) {
                writer.write(errorText);
                writer.flush();
                return;
            }
            try {
                List<AccountInfo> members = this.apply(group.getGroupUUID());
                ColumnFormatter formatter = new ColumnFormatter(writer, '\t');
                formatter.addColumn("id");
                formatter.addColumn("username");
                formatter.addColumn("full name");
                formatter.addColumn("email");
                formatter.nextLine();
                for (AccountInfo member : members) {
                    if (member == null) continue;
                    formatter.addColumn(member._id.toString());
                    formatter.addColumn(Objects.firstNonNull(member.username, "n/a"));
                    formatter.addColumn(Objects.firstNonNull(Strings.emptyToNull(member.name), "n/a"));
                    formatter.addColumn(Objects.firstNonNull(member.email, "n/a"));
                    formatter.nextLine();
                }
                formatter.finish();
            }
            catch (MethodNotAllowedException e) {
                writer.write(errorText);
                writer.flush();
            }
        }
    }
}

