/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.common.AbstractAgentProxy;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.util.Buffer;

public class AgentForwardedChannel
extends AbstractClientChannel {
    private final Queue<Buffer> messages = new ArrayBlockingQueue<Buffer>(10);
    private final Buffer receiveBuffer = new Buffer();

    public AgentForwardedChannel() {
        super("auth-agent@openssh.com");
    }

    public SshAgent getAgent() {
        return new AbstractAgentProxy(){

            protected Buffer request(Buffer buffer) throws IOException {
                return AgentForwardedChannel.this.request(buffer);
            }

            public void close() {
                AgentForwardedChannel.this.close(false);
            }
        };
    }

    protected Buffer request(Buffer buffer) throws IOException {
        Queue<Buffer> queue = this.messages;
        synchronized (queue) {
            try {
                this.getInvertedIn().write(buffer.array(), buffer.rpos(), buffer.available());
                this.getInvertedIn().flush();
                this.localWindow.consumeAndCheck(buffer.available());
                if (this.messages.isEmpty()) {
                    this.messages.wait();
                }
                return this.messages.poll();
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }
    }

    public OpenFuture open() throws IOException {
        return this.internalOpen();
    }

    protected void doOpen() throws IOException {
        this.invertedIn = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_DATA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        Buffer message = null;
        Object object = this.receiveBuffer;
        synchronized (object) {
            this.receiveBuffer.putBuffer(new Buffer(data, off, len));
            if (this.receiveBuffer.available() >= 4) {
                off = this.receiveBuffer.rpos();
                len = this.receiveBuffer.getInt();
                this.receiveBuffer.rpos(off);
                if (this.receiveBuffer.available() >= 4 + len) {
                    message = new Buffer(this.receiveBuffer.getBytes());
                    this.receiveBuffer.compact();
                }
            }
        }
        if (message != null) {
            object = this.messages;
            synchronized (object) {
                this.messages.offer(message);
                this.messages.notifyAll();
            }
        }
    }
}

