/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.io.IoCloseFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.Readable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nio2Session
implements IoSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(Nio2Session.class);
    private static final AtomicLong sessionIdGenerator = new AtomicLong(100L);
    private final long id = sessionIdGenerator.incrementAndGet();
    private final Nio2Service service;
    private final IoHandler handler;
    private final AsynchronousSocketChannel socket;
    private final Map<Object, Object> attributes = new HashMap<Object, Object>();
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final AtomicBoolean closing = new AtomicBoolean();
    private final IoCloseFuture closeFuture = new DefaultIoCloseFuture(null);
    private final Queue<DefaultIoWriteFuture> writes = new LinkedTransferQueue<DefaultIoWriteFuture>();
    private final AtomicReference<DefaultIoWriteFuture> currentWrite = new AtomicReference();

    public Nio2Session(Nio2Service service, IoHandler handler, AsynchronousSocketChannel socket) throws IOException {
        this.service = service;
        this.handler = handler;
        this.socket = socket;
        this.localAddress = socket.getLocalAddress();
        this.remoteAddress = socket.getRemoteAddress();
        LOGGER.debug("Creating Nio2Session on {} from {}", (Object)this.localAddress, (Object)this.remoteAddress);
    }

    public long getId() {
        return this.id;
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public void suspend() {
        try {
            this.socket.shutdownInput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public IoWriteFuture write(Buffer buffer) {
        LOGGER.debug("Writing {} bytes", (Object)buffer.available());
        ByteBuffer buf = ByteBuffer.wrap(buffer.array(), buffer.rpos(), buffer.available());
        DefaultIoWriteFuture future = new DefaultIoWriteFuture(null, buf);
        if (this.closing.get()) {
            ClosedChannelException exc = new ClosedChannelException();
            future.setException(exc);
            this.exceptionCaught(exc);
            return future;
        }
        this.writes.add(future);
        this.startWriting();
        return future;
    }

    private void exceptionCaught(Throwable exc) {
        if (!this.closing.get()) {
            if (!this.socket.isOpen()) {
                this.close(true);
            } else {
                try {
                    LOGGER.debug("Caught exception, now calling handler");
                    this.handler.exceptionCaught(this, exc);
                }
                catch (Throwable t) {
                    LOGGER.info("Exception handler threw exception, closing the session", t);
                    this.close(true);
                }
            }
        }
    }

    private void startWriting() {
        final DefaultIoWriteFuture future = this.writes.peek();
        if (future != null && this.currentWrite.compareAndSet(null, future)) {
            this.socket.write(future.buffer, null, new CompletionHandler<Integer, Object>(){

                @Override
                public void completed(Integer result, Object attachment) {
                    future.setWritten();
                    this.finishWrite();
                }

                @Override
                public void failed(Throwable exc, Object attachment) {
                    future.setException(exc);
                    Nio2Session.this.exceptionCaught(exc);
                    this.finishWrite();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void finishWrite() {
                    Queue queue = Nio2Session.this.writes;
                    synchronized (queue) {
                        Nio2Session.this.writes.remove(future);
                        Nio2Session.this.writes.notifyAll();
                    }
                    Nio2Session.this.currentWrite.compareAndSet(future, null);
                    Nio2Session.this.startWriting();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoCloseFuture close(boolean immediately) {
        if (this.closing.compareAndSet(false, true)) {
            DefaultIoWriteFuture future;
            LOGGER.debug("Closing Nio2Session");
            if (!immediately) {
                try {
                    boolean logged = false;
                    Queue<DefaultIoWriteFuture> queue = this.writes;
                    synchronized (queue) {
                        while (!this.writes.isEmpty()) {
                            if (!logged) {
                                LOGGER.debug("Waiting for writes to finish");
                                logged = true;
                            }
                            this.writes.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            while ((future = this.writes.poll()) != null) {
                future.setException(new ClosedChannelException());
            }
            try {
                LOGGER.debug("Closing socket");
                this.socket.close();
            }
            catch (IOException e) {
                LOGGER.info("Exception caught while closing session", e);
            }
            this.service.sessionClosed(this);
            this.closeFuture.setClosed();
            try {
                this.handler.sessionClosed(this);
            }
            catch (Exception e) {
                LOGGER.debug("Exception caught while calling IoHandler#sessionClosed", e);
            }
        }
        return this.closeFuture;
    }

    public IoService getService() {
        return this.service;
    }

    public void startReading() {
        final ByteBuffer buffer = ByteBuffer.allocate(32768);
        this.socket.read(buffer, null, new CompletionHandler<Integer, Object>(){

            @Override
            public void completed(Integer result, Object attachment) {
                try {
                    if (result >= 0) {
                        LOGGER.debug("Read {} bytes", (Object)result);
                        buffer.flip();
                        Readable buf = new Readable(){

                            public int available() {
                                return buffer.remaining();
                            }

                            public void getRawBytes(byte[] data, int offset, int len) {
                                buffer.get(data, offset, len);
                            }
                        };
                        Nio2Session.this.handler.messageReceived(Nio2Session.this, buf);
                        Nio2Session.this.startReading();
                    } else {
                        LOGGER.debug("Socket has been disconnected, closing IoSession now");
                        Nio2Session.this.close(true);
                    }
                }
                catch (Throwable exc) {
                    this.failed(exc, attachment);
                }
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                Nio2Session.this.exceptionCaught(exc);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultIoWriteFuture
    extends DefaultSshFuture<IoWriteFuture>
    implements IoWriteFuture {
        private final ByteBuffer buffer;

        DefaultIoWriteFuture(Object lock, ByteBuffer buffer) {
            super(lock);
            this.buffer = buffer;
        }

        @Override
        public boolean isWritten() {
            return this.getValue() instanceof Boolean;
        }

        @Override
        public void setWritten() {
            this.setValue(Boolean.TRUE);
        }

        @Override
        public Throwable getException() {
            Object v = this.getValue();
            return v instanceof Throwable ? (Throwable)v : null;
        }

        @Override
        public void setException(Throwable exception) {
            if (exception == null) {
                throw new IllegalArgumentException("exception");
            }
            this.setValue(exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultIoCloseFuture
    extends DefaultSshFuture<IoCloseFuture>
    implements IoCloseFuture {
        DefaultIoCloseFuture(Object lock) {
            super(lock);
        }

        @Override
        public boolean isClosed() {
            return this.getValue() instanceof Boolean;
        }

        @Override
        public void setClosed() {
            this.setValue(Boolean.TRUE);
        }
    }
}

