/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.GroupInfo;
import com.google.gerrit.reviewdb.client.AccountGroup;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GroupInfoCache {
    private static final GroupInfoCache EMPTY = new GroupInfoCache();
    protected Map<AccountGroup.UUID, GroupInfo> groups;

    public static GroupInfoCache empty() {
        return EMPTY;
    }

    protected GroupInfoCache() {
    }

    public GroupInfoCache(Iterable<GroupInfo> list) {
        this.groups = new HashMap<AccountGroup.UUID, GroupInfo>();
        for (GroupInfo gi : list) {
            this.groups.put(gi.getId(), gi);
        }
    }

    public GroupInfo get(AccountGroup.UUID uuid) {
        if (uuid == null) {
            return null;
        }
        GroupInfo r = this.groups.get(uuid);
        if (r == null) {
            r = new GroupInfo(uuid);
            this.groups.put(uuid, r);
        }
        return r;
    }

    public void merge(GroupInfoCache other) {
        assert (this != EMPTY);
        this.groups.putAll(other.groups);
    }

    static {
        GroupInfoCache.EMPTY.groups = Collections.emptyMap();
    }
}

