/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountDirectory;
import com.google.gerrit.server.account.InternalAccountDirectory;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AccountInfo {
    public transient Account.Id _id;
    public Integer _accountId;
    public String name;
    public String email;
    public String username;
    public List<AvatarInfo> avatars;

    public AccountInfo(Account.Id id) {
        this._id = id;
    }

    public static class AvatarInfo {
        public static final int DEFAULT_SIZE = 26;
        public String url;
        public Integer height;
        public Integer width;
    }

    public static class Loader {
        private static final Set<AccountDirectory.FillOptions> DETAILED_OPTIONS = Collections.unmodifiableSet(EnumSet.of(AccountDirectory.FillOptions.NAME, AccountDirectory.FillOptions.EMAIL, AccountDirectory.FillOptions.USERNAME, AccountDirectory.FillOptions.AVATARS));
        private final InternalAccountDirectory directory;
        private final boolean detailed;
        private final Map<Account.Id, AccountInfo> created;
        private final List<AccountInfo> provided;

        @Inject
        Loader(InternalAccountDirectory directory, @Assisted boolean detailed) {
            this.directory = directory;
            this.detailed = detailed;
            this.created = Maps.newHashMap();
            this.provided = Lists.newArrayList();
        }

        public AccountInfo get(Account.Id id) {
            if (id == null) {
                return null;
            }
            AccountInfo info = this.created.get(id);
            if (info == null) {
                info = new AccountInfo(id);
                if (this.detailed) {
                    info._accountId = id.get();
                }
                this.created.put(id, info);
            }
            return info;
        }

        public void put(AccountInfo info) {
            if (this.detailed) {
                info._accountId = info._id.get();
            }
            this.provided.add(info);
        }

        public void fill() throws OrmException {
            try {
                this.directory.fillAccountInfo(Iterables.concat(this.created.values(), this.provided), this.detailed ? DETAILED_OPTIONS : EnumSet.of(AccountDirectory.FillOptions.NAME));
            }
            catch (AccountDirectory.DirectoryException e) {
                Throwables.propagateIfPossible(e.getCause(), OrmException.class);
                throw new OrmException(e);
            }
        }

        public void fill(Collection<? extends AccountInfo> infos) throws OrmException {
            for (AccountInfo accountInfo : infos) {
                this.put(accountInfo);
            }
            this.fill();
        }

        public static interface Factory {
            public Loader create(boolean var1);
        }
    }
}

