/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.inject.TypeLiteral;

public class AccountResource
implements RestResource {
    public static final TypeLiteral<RestView<AccountResource>> ACCOUNT_KIND = new TypeLiteral<RestView<AccountResource>>(){};
    public static final TypeLiteral<RestView<Capability>> CAPABILITY_KIND = new TypeLiteral<RestView<Capability>>(){};
    public static final TypeLiteral<RestView<Email>> EMAIL_KIND = new TypeLiteral<RestView<Email>>(){};
    public static final TypeLiteral<RestView<SshKey>> SSH_KEY_KIND = new TypeLiteral<RestView<SshKey>>(){};
    public static final TypeLiteral<RestView<StarredChange>> STARRED_CHANGE_KIND = new TypeLiteral<RestView<StarredChange>>(){};
    private final IdentifiedUser user;

    public AccountResource(IdentifiedUser user) {
        this.user = user;
    }

    public IdentifiedUser getUser() {
        return this.user;
    }

    public static class StarredChange
    extends AccountResource {
        private final ChangeResource change;

        public StarredChange(IdentifiedUser user, ChangeResource change) {
            super(user);
            this.change = change;
        }

        public Change getChange() {
            return this.change.getChange();
        }
    }

    public static class SshKey
    extends AccountResource {
        private final AccountSshKey sshKey;

        public SshKey(IdentifiedUser user, AccountSshKey sshKey) {
            super(user);
            this.sshKey = sshKey;
        }

        public AccountSshKey getSshKey() {
            return this.sshKey;
        }
    }

    public static class Email
    extends AccountResource {
        private final String email;

        public Email(IdentifiedUser user, String email) {
            super(user);
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }
    }

    static class Capability
    implements RestResource {
        private final IdentifiedUser user;
        private final String capability;

        Capability(IdentifiedUser user, String capability) {
            this.user = user;
            this.capability = capability;
        }

        public IdentifiedUser getUser() {
            return this.user;
        }

        public String getCapability() {
            return this.capability;
        }

        public boolean has() {
            return this.user.getCapabilities().canPerform(this.getCapability());
        }
    }
}

