/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AuthType;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountByEmailCache;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.EmailExpander;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.config.AuthConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Set;

@Singleton
public class DefaultRealm
implements Realm {
    private final EmailExpander emailExpander;
    private final AccountByEmailCache byEmail;
    private final AuthConfig authConfig;

    @Inject
    DefaultRealm(EmailExpander emailExpander, AccountByEmailCache byEmail, AuthConfig authConfig) {
        this.emailExpander = emailExpander;
        this.byEmail = byEmail;
        this.authConfig = authConfig;
    }

    @Override
    public boolean allowsEdit(Account.FieldName field) {
        if (this.authConfig.getAuthType() == AuthType.HTTP || this.authConfig.getAuthType() == AuthType.OAUTH) {
            switch (field) {
                case USER_NAME: {
                    return false;
                }
                case FULL_NAME: {
                    return Strings.emptyToNull(this.authConfig.getHttpDisplaynameHeader()) == null;
                }
                case REGISTER_NEW_EMAIL: {
                    return Strings.emptyToNull(this.authConfig.getHttpEmailHeader()) == null;
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public AuthRequest authenticate(AuthRequest who) {
        if (who.getEmailAddress() == null && who.getLocalUser() != null && this.emailExpander.canExpand(who.getLocalUser())) {
            who.setEmailAddress(this.emailExpander.expand(who.getLocalUser()));
        }
        return who;
    }

    @Override
    public AuthRequest link(ReviewDb db, Account.Id to, AuthRequest who) {
        return who;
    }

    @Override
    public AuthRequest unlink(ReviewDb db, Account.Id from, AuthRequest who) {
        return who;
    }

    @Override
    public void onCreateAccount(AuthRequest who, Account account) {
    }

    @Override
    public Account.Id lookup(String accountName) {
        Set<Account.Id> c;
        if (this.emailExpander.canExpand(accountName) && 1 == (c = this.byEmail.get(this.emailExpander.expand(accountName))).size()) {
            return c.iterator().next();
        }
        return null;
    }
}

