/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.errors.NameAlreadyUsedException;
import com.google.gerrit.common.errors.PermissionDeniedException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.client.AccountGroupByIdAud;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.client.AccountGroupMemberAudit;
import com.google.gerrit.reviewdb.client.AccountGroupName;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.CreateGroupArgs;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupIncludeCache;
import com.google.gerrit.server.account.GroupUUID;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.lib.PersonIdent;

public class PerformCreateGroup {
    private final ReviewDb db;
    private final AccountCache accountCache;
    private final GroupIncludeCache groupIncludeCache;
    private final IdentifiedUser currentUser;
    private final PersonIdent serverIdent;
    private final GroupCache groupCache;
    private final CreateGroupArgs createGroupArgs;

    @Inject
    PerformCreateGroup(ReviewDb db, AccountCache accountCache, GroupIncludeCache groupIncludeCache, IdentifiedUser currentUser, @GerritPersonIdent PersonIdent serverIdent, GroupCache groupCache, @Assisted CreateGroupArgs createGroupArgs) {
        this.db = db;
        this.accountCache = accountCache;
        this.groupIncludeCache = groupIncludeCache;
        this.currentUser = currentUser;
        this.serverIdent = serverIdent;
        this.groupCache = groupCache;
        this.createGroupArgs = createGroupArgs;
    }

    public AccountGroup createGroup() throws OrmException, NameAlreadyUsedException, PermissionDeniedException {
        AccountGroup ownerGroup;
        if (!this.currentUser.getCapabilities().canCreateGroup()) {
            throw new PermissionDeniedException(String.format("%s does not have \"Create Group\" capability.", this.currentUser.getUserName()));
        }
        AccountGroup.Id groupId = new AccountGroup.Id(this.db.nextAccountGroupId());
        AccountGroup.UUID uuid = GroupUUID.make(this.createGroupArgs.getGroupName(), this.currentUser.newCommitterIdent(this.serverIdent.getWhen(), this.serverIdent.getTimeZone()));
        AccountGroup group = new AccountGroup(this.createGroupArgs.getGroup(), groupId, uuid);
        group.setVisibleToAll(this.createGroupArgs.visibleToAll);
        if (this.createGroupArgs.ownerGroupId != null && (ownerGroup = this.groupCache.get(this.createGroupArgs.ownerGroupId)) != null) {
            group.setOwnerGroupUUID(ownerGroup.getGroupUUID());
        }
        if (this.createGroupArgs.groupDescription != null) {
            group.setDescription(this.createGroupArgs.groupDescription);
        }
        AccountGroupName gn = new AccountGroupName(group);
        try {
            this.db.accountGroupNames().insert(Collections.singleton(gn));
        }
        catch (OrmDuplicateKeyException e) {
            throw new NameAlreadyUsedException(this.createGroupArgs.getGroupName());
        }
        this.db.accountGroups().insert(Collections.singleton(group));
        this.addMembers(groupId, this.createGroupArgs.initialMembers);
        if (this.createGroupArgs.initialGroups != null) {
            this.addGroups(groupId, this.createGroupArgs.initialGroups);
            this.groupIncludeCache.evictSubgroupsOf(uuid);
        }
        this.groupCache.onCreateGroup(this.createGroupArgs.getGroup());
        return group;
    }

    private void addMembers(AccountGroup.Id groupId, Collection<? extends Account.Id> members) throws OrmException {
        ArrayList<AccountGroupMember> memberships = new ArrayList<AccountGroupMember>();
        ArrayList<AccountGroupMemberAudit> membershipsAudit = new ArrayList<AccountGroupMemberAudit>();
        for (Account.Id id : members) {
            AccountGroupMember membership = new AccountGroupMember(new AccountGroupMember.Key(id, groupId));
            memberships.add(membership);
            AccountGroupMemberAudit audit = new AccountGroupMemberAudit(membership, this.currentUser.getAccountId(), TimeUtil.nowTs());
            membershipsAudit.add(audit);
        }
        this.db.accountGroupMembers().insert(memberships);
        this.db.accountGroupMembersAudit().insert(membershipsAudit);
        for (Account.Id id : members) {
            this.accountCache.evict(id);
        }
    }

    private void addGroups(AccountGroup.Id groupId, Collection<? extends AccountGroup.UUID> groups) throws OrmException {
        ArrayList<AccountGroupById> includeList = new ArrayList<AccountGroupById>();
        ArrayList<AccountGroupByIdAud> includesAudit = new ArrayList<AccountGroupByIdAud>();
        for (AccountGroup.UUID uUID : groups) {
            AccountGroupById groupInclude = new AccountGroupById(new AccountGroupById.Key(groupId, uUID));
            includeList.add(groupInclude);
            AccountGroupByIdAud audit = new AccountGroupByIdAud(groupInclude, this.currentUser.getAccountId(), TimeUtil.nowTs());
            includesAudit.add(audit);
        }
        this.db.accountGroupById().insert(includeList);
        this.db.accountGroupByIdAud().insert(includesAudit);
        for (AccountGroup.UUID uUID : groups) {
            this.groupIncludeCache.evictParentGroupsOf(uUID);
        }
    }

    public static interface Factory {
        public PerformCreateGroup create(CreateGroupArgs var1);
    }
}

