/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.util.concurrent.CheckedFuture;
import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.change.MergeabilityChecker;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.mail.CreateChangeSender;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.RefControl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeInserter {
    private static final Logger log = LoggerFactory.getLogger(ChangeInserter.class);
    private final Provider<ReviewDb> dbProvider;
    private final ChangeUpdate.Factory updateFactory;
    private final GitReferenceUpdated gitRefUpdated;
    private final ChangeHooks hooks;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeMessagesUtil cmUtil;
    private final MergeabilityChecker mergeabilityChecker;
    private final CreateChangeSender.Factory createChangeSenderFactory;
    private final RefControl refControl;
    private final Change change;
    private final PatchSet patchSet;
    private final RevCommit commit;
    private final PatchSetInfo patchSetInfo;
    private ChangeMessage changeMessage;
    private Set<Account.Id> reviewers;
    private Set<Account.Id> extraCC;
    private Map<String, Short> approvals;
    private boolean runHooks;
    private boolean sendMail;

    @Inject
    ChangeInserter(Provider<ReviewDb> dbProvider, ChangeUpdate.Factory updateFactory, PatchSetInfoFactory patchSetInfoFactory, GitReferenceUpdated gitRefUpdated, ChangeHooks hooks, ApprovalsUtil approvalsUtil, ChangeMessagesUtil cmUtil, MergeabilityChecker mergeabilityChecker, CreateChangeSender.Factory createChangeSenderFactory, @Assisted RefControl refControl, @Assisted Change change, @Assisted RevCommit commit) {
        this.dbProvider = dbProvider;
        this.updateFactory = updateFactory;
        this.gitRefUpdated = gitRefUpdated;
        this.hooks = hooks;
        this.approvalsUtil = approvalsUtil;
        this.cmUtil = cmUtil;
        this.mergeabilityChecker = mergeabilityChecker;
        this.createChangeSenderFactory = createChangeSenderFactory;
        this.refControl = refControl;
        this.change = change;
        this.commit = commit;
        this.reviewers = Collections.emptySet();
        this.extraCC = Collections.emptySet();
        this.approvals = Collections.emptyMap();
        this.runHooks = true;
        this.sendMail = true;
        this.patchSet = new PatchSet(new PatchSet.Id(change.getId(), 1));
        this.patchSet.setCreatedOn(change.getCreatedOn());
        this.patchSet.setUploader(change.getOwner());
        this.patchSet.setRevision(new RevId(commit.name()));
        this.patchSetInfo = patchSetInfoFactory.get(commit, this.patchSet.getId());
        change.setCurrentPatchSet(this.patchSetInfo);
        ChangeUtil.computeSortKey(change);
    }

    public Change getChange() {
        return this.change;
    }

    public ChangeInserter setMessage(ChangeMessage changeMessage) {
        this.changeMessage = changeMessage;
        return this;
    }

    public ChangeInserter setReviewers(Set<Account.Id> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public ChangeInserter setExtraCC(Set<Account.Id> extraCC) {
        this.extraCC = extraCC;
        return this;
    }

    public ChangeInserter setDraft(boolean draft) {
        this.change.setStatus(draft ? Change.Status.DRAFT : Change.Status.NEW);
        this.patchSet.setDraft(draft);
        return this;
    }

    public ChangeInserter setRunHooks(boolean runHooks) {
        this.runHooks = runHooks;
        return this;
    }

    public ChangeInserter setSendMail(boolean sendMail) {
        this.sendMail = sendMail;
        return this;
    }

    public PatchSet getPatchSet() {
        return this.patchSet;
    }

    public ChangeInserter setApprovals(Map<String, Short> approvals) {
        this.approvals = approvals;
        return this;
    }

    public PatchSetInfo getPatchSetInfo() {
        return this.patchSetInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change insert() throws OrmException, IOException {
        ReviewDb db = this.dbProvider.get();
        ChangeControl ctl = this.refControl.getProjectControl().controlFor(this.change);
        ChangeUpdate update = this.updateFactory.create(ctl, this.change.getCreatedOn());
        db.changes().beginTransaction(this.change.getId());
        try {
            ChangeUtil.insertAncestors(db, this.patchSet.getId(), this.commit);
            db.patchSets().insert(Collections.singleton(this.patchSet));
            db.changes().insert(Collections.singleton(this.change));
            LabelTypes labelTypes = this.refControl.getProjectControl().getLabelTypes();
            this.approvalsUtil.addReviewers(db, update, labelTypes, this.change, this.patchSet, this.patchSetInfo, this.reviewers, Collections.emptySet());
            this.approvalsUtil.addApprovals(db, update, labelTypes, this.patchSet, this.patchSetInfo, this.change, ctl, this.approvals);
            if (this.messageIsForChange()) {
                this.cmUtil.addChangeMessage(db, update, this.changeMessage);
            }
            db.commit();
        }
        finally {
            db.rollback();
        }
        update.commit();
        CheckedFuture<?, IOException> f = this.mergeabilityChecker.newCheck().addChange(this.change).reindex().runAsync();
        if (!this.messageIsForChange()) {
            this.commitMessageNotForChange();
        }
        if (this.sendMail) {
            try {
                CreateChangeSender cm = this.createChangeSenderFactory.create(this.change);
                cm.setFrom(this.change.getOwner());
                cm.setPatchSet(this.patchSet, this.patchSetInfo);
                cm.addReviewers(this.reviewers);
                cm.addExtraCC(this.extraCC);
                cm.send();
            }
            catch (Exception err) {
                log.error("Cannot send email for new change " + this.change.getId(), err);
            }
        }
        f.checkedGet();
        this.gitRefUpdated.fire(this.change.getProject(), this.patchSet.getRefName(), ObjectId.zeroId(), this.commit);
        if (this.runHooks) {
            this.hooks.doPatchsetCreatedHook(this.change, this.patchSet, db);
        }
        return this.change;
    }

    private void commitMessageNotForChange() throws OrmException, IOException {
        ReviewDb db = this.dbProvider.get();
        if (this.changeMessage != null) {
            Change otherChange = db.changes().get(this.changeMessage.getPatchSetId().getParentKey());
            ChangeUtil.bumpRowVersionNotLastUpdatedOn(this.changeMessage.getKey().getParentKey(), db);
            ChangeControl otherControl = this.refControl.getProjectControl().controlFor(otherChange);
            ChangeUpdate updateForOtherChange = this.updateFactory.create(otherControl, this.change.getLastUpdatedOn());
            this.cmUtil.addChangeMessage(db, updateForOtherChange, this.changeMessage);
            updateForOtherChange.commit();
        }
    }

    private boolean messageIsForChange() {
        if (this.changeMessage == null) {
            return false;
        }
        Change.Id id = this.change.getId();
        Change.Id msgId = this.changeMessage.getKey().getParentKey();
        return msgId.equals(id);
    }

    public static interface Factory {
        public ChangeInserter create(RefControl var1, Change var2, RevCommit var3);
    }
}

