/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.change.ArchiveFormat;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;

public class GetArchive
implements RestReadView<RevisionResource> {
    private final GitRepositoryManager repoManager;
    private final AllowedFormats allowedFormats;
    @Option(name="--format")
    private String format;

    @Inject
    GetArchive(GitRepositoryManager repoManager, AllowedFormats allowedFormats) {
        this.repoManager = repoManager;
        this.allowedFormats = allowedFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryResult apply(RevisionResource rsrc) throws BadRequestException, IOException {
        if (Strings.isNullOrEmpty(this.format)) {
            throw new BadRequestException("format is not specified");
        }
        final ArchiveFormat f = this.allowedFormats.extensions.get("." + this.format);
        if (f == null) {
            throw new BadRequestException("unknown archive format");
        }
        boolean close = true;
        final Repository repo = this.repoManager.openRepository(rsrc.getControl().getProject().getNameKey());
        try {
            final RevWalk rw = new RevWalk(repo);
            try {
                final RevCommit commit = rw.parseCommit(ObjectId.fromString(rsrc.getPatchSet().getRevision().get()));
                BinaryResult bin = new BinaryResult(){

                    @Override
                    public void writeTo(OutputStream out) throws IOException {
                        try {
                            new ArchiveCommand(repo).setFormat(f.name()).setTree(commit.getTree()).setOutputStream(out).call();
                        }
                        catch (GitAPIException e) {
                            throw new IOException(e);
                        }
                    }

                    @Override
                    public void close() throws IOException {
                        rw.release();
                        repo.close();
                    }
                };
                bin.disableGzip().setContentType(f.getMimeType()).setAttachmentName(GetArchive.name(f, rw, commit));
                close = false;
                BinaryResult binaryResult = bin;
                if (close) {
                    rw.release();
                }
                return binaryResult;
            }
            catch (Throwable throwable) {
                if (close) {
                    rw.release();
                }
                throw throwable;
            }
        }
        finally {
            if (close) {
                repo.close();
            }
        }
    }

    private static String name(ArchiveFormat format, RevWalk rw, RevCommit commit) throws IOException {
        return String.format("%s%s", rw.getObjectReader().abbreviate(commit, 7).name(), format.getDefaultSuffix());
    }

    @Singleton
    public static class AllowedFormats {
        final ImmutableMap<String, ArchiveFormat> extensions;
        final Set<ArchiveFormat> allowed;

        @Inject
        AllowedFormats(@GerritServerConfig Config cfg) {
            String v = cfg.getString("download", null, "archive");
            List<Object> enabled = v == null ? Arrays.asList(ArchiveFormat.values()) : (v.isEmpty() || "off".equalsIgnoreCase(v) ? Collections.emptyList() : ConfigUtil.getEnumList(cfg, "download", null, "archive", ArchiveFormat.TGZ));
            HashMap<String, ArchiveFormat> exts = new HashMap<String, ArchiveFormat>();
            for (ArchiveFormat format : enabled) {
                for (String ext : format.getSuffixes()) {
                    exts.put(ext, format);
                }
                exts.put(format.name().toLowerCase(), format);
            }
            this.extensions = ImmutableMap.copyOf(exts);
            this.allowed = Collections.unmodifiableSet(new LinkedHashSet<ArchiveFormat>(enabled));
        }

        public Set<ArchiveFormat> getAllowed() {
            return this.allowed;
        }
    }
}

