/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.ListChangesOption;
import com.google.gerrit.extensions.restapi.CacheControl;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.kohsuke.args4j.Option;

public class GetChange
implements RestReadView<ChangeResource> {
    private final ChangeJson json;

    @Option(name="-o", usage="Output options")
    void addOption(ListChangesOption o) {
        this.json.addOption(o);
    }

    @Option(name="-O", usage="Output option flags, in hex")
    void setOptionFlagsHex(String hex) {
        this.json.addOptions(ListChangesOption.fromBits(Integer.parseInt(hex, 16)));
    }

    @Inject
    GetChange(ChangeJson json) {
        this.json = json;
    }

    public Response<ChangeJson.ChangeInfo> apply(ChangeResource rsrc) throws OrmException {
        return this.cache(this.json.format(rsrc));
    }

    Response<ChangeJson.ChangeInfo> apply(RevisionResource rsrc) throws OrmException {
        return this.cache(this.json.format(rsrc));
    }

    private Response<ChangeJson.ChangeInfo> cache(ChangeJson.ChangeInfo res) {
        return Response.ok(res).caching(CacheControl.PRIVATE(0L, TimeUnit.SECONDS).setMustRevalidate());
    }
}

