/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.account.GetPreferences;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class GetPreferences
implements RestReadView<ConfigResource> {
    private final AllUsersName allUsersName;
    private final GitRepositoryManager gitMgr;

    @Inject
    public GetPreferences(AllUsersName allUsersName, GitRepositoryManager gitMgr) {
        this.allUsersName = allUsersName;
        this.gitMgr = gitMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetPreferences.PreferenceInfo apply(ConfigResource rsrc) throws IOException, ConfigInvalidException {
        try (Repository git = this.gitMgr.openRepository(this.allUsersName);){
            VersionedAccountPreferences p = VersionedAccountPreferences.forDefault();
            p.load(git);
            GetPreferences.PreferenceInfo preferenceInfo = new GetPreferences.PreferenceInfo(null, p, git);
            return preferenceInfo;
        }
    }
}

