/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.ListTasks;
import com.google.gerrit.server.config.TaskResource;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class TasksCollection
implements ChildCollection<ConfigResource, TaskResource> {
    private final DynamicMap<RestView<TaskResource>> views;
    private final ListTasks list;
    private final WorkQueue workQueue;
    private final Provider<IdentifiedUser> self;
    private final ProjectCache projectCache;

    @Inject
    TasksCollection(DynamicMap<RestView<TaskResource>> views, ListTasks list, WorkQueue workQueue, Provider<IdentifiedUser> self, ProjectCache projectCache) {
        this.views = views;
        this.list = list;
        this.workQueue = workQueue;
        this.self = self;
        this.projectCache = projectCache;
    }

    @Override
    public RestView<ConfigResource> list() {
        return this.list;
    }

    @Override
    public TaskResource parse(ConfigResource parent, IdString id) throws ResourceNotFoundException, AuthException {
        CurrentUser user = this.self.get();
        if (!user.isIdentifiedUser()) {
            throw new AuthException("Authentication required");
        }
        try {
            int taskId = (int)Long.parseLong(id.get(), 16);
            WorkQueue.Task<?> task = this.workQueue.getTask(taskId);
            if (task != null) {
                WorkQueue.ProjectTask projectTask;
                ProjectState e;
                if (this.self.get().getCapabilities().canViewQueue()) {
                    return new TaskResource(task);
                }
                if (task instanceof WorkQueue.ProjectTask && (e = this.projectCache.get((projectTask = (WorkQueue.ProjectTask)task).getProjectNameKey())) != null && e.controlFor(user).isVisible()) {
                    return new TaskResource(task);
                }
            }
            throw new ResourceNotFoundException(id);
        }
        catch (NumberFormatException e) {
            throw new ResourceNotFoundException(id);
        }
    }

    @Override
    public DynamicMap<RestView<TaskResource>> views() {
        return this.views;
    }
}

