/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.account.ListGroupMembership;
import com.google.gerrit.server.project.ProjectControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SystemGroupBackend
implements GroupBackend {
    public static final AccountGroup.UUID ANONYMOUS_USERS;
    public static final AccountGroup.UUID REGISTERED_USERS;
    public static final AccountGroup.UUID PROJECT_OWNERS;
    public static final AccountGroup.UUID CHANGE_OWNER;
    private static final SortedMap<String, GroupReference> names;
    private static final ImmutableMap<AccountGroup.UUID, GroupReference> uuids;

    public static boolean isSystemGroup(AccountGroup.UUID uuid) {
        return uuid.get().startsWith("global:");
    }

    public static boolean isAnonymousOrRegistered(GroupReference ref) {
        return SystemGroupBackend.isAnonymousOrRegistered(ref.getUUID());
    }

    public static boolean isAnonymousOrRegistered(AccountGroup.UUID uuid) {
        return ANONYMOUS_USERS.equals(uuid) || REGISTERED_USERS.equals(uuid);
    }

    public static GroupReference getGroup(AccountGroup.UUID uuid) {
        return Preconditions.checkNotNull(uuids.get(uuid), "group %s not found", uuid.get());
    }

    @Override
    public boolean handles(AccountGroup.UUID uuid) {
        return SystemGroupBackend.isSystemGroup(uuid);
    }

    @Override
    public GroupDescription.Basic get(AccountGroup.UUID uuid) {
        final GroupReference ref = SystemGroupBackend.getGroup(uuid);
        if (ref != null) {
            return new GroupDescription.Basic(){

                @Override
                public String getName() {
                    return ref.getName();
                }

                @Override
                public AccountGroup.UUID getGroupUUID() {
                    return ref.getUUID();
                }

                @Override
                public String getUrl() {
                    return null;
                }

                @Override
                public String getEmailAddress() {
                    return null;
                }
            };
        }
        return null;
    }

    @Override
    public Collection<GroupReference> suggest(String name, ProjectControl project) {
        String nameLC = name.toLowerCase(Locale.US);
        SortedMap<String, GroupReference> matches = names.tailMap(nameLC);
        if (matches.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GroupReference> r = new ArrayList<GroupReference>(matches.size());
        for (Map.Entry<String, GroupReference> e : matches.entrySet()) {
            if (!e.getKey().startsWith(nameLC)) break;
            r.add(e.getValue());
        }
        return r;
    }

    @Override
    public GroupMembership membershipsOf(IdentifiedUser user) {
        return new ListGroupMembership(ImmutableSet.of(ANONYMOUS_USERS, REGISTERED_USERS));
    }

    static {
        AccountGroup.UUID[] all;
        ANONYMOUS_USERS = new AccountGroup.UUID("global:Anonymous-Users");
        REGISTERED_USERS = new AccountGroup.UUID("global:Registered-Users");
        PROJECT_OWNERS = new AccountGroup.UUID("global:Project-Owners");
        CHANGE_OWNER = new AccountGroup.UUID("global:Change-Owner");
        TreeMap<String, GroupReference> n = new TreeMap<String, GroupReference>();
        ImmutableMap.Builder<AccountGroup.UUID, GroupReference> u = ImmutableMap.builder();
        for (AccountGroup.UUID uuid : all = new AccountGroup.UUID[]{ANONYMOUS_USERS, REGISTERED_USERS, PROJECT_OWNERS, CHANGE_OWNER}) {
            int c = uuid.get().indexOf(58);
            String name = uuid.get().substring(c + 1).replace('-', ' ');
            GroupReference ref = new GroupReference(uuid, name);
            n.put(ref.getName().toLowerCase(Locale.US), ref);
            u.put(ref.getUUID(), ref);
        }
        names = Collections.unmodifiableSortedMap(n);
        uuids = u.build();
    }
}

