/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.webui.JavaScriptPlugin;
import com.google.gerrit.extensions.webui.WebUiPlugin;
import com.google.gerrit.lifecycle.LifecycleManager;
import com.google.gerrit.server.PluginUser;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.PluginContentScanner;
import com.google.gerrit.server.plugins.PluginGuiceEnvironment;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.io.File;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;

class JsPlugin
extends Plugin {
    private Injector httpInjector;

    JsPlugin(String name, File srcFile, PluginUser pluginUser, FileSnapshot snapshot) {
        super(name, srcFile, pluginUser, snapshot, Plugin.ApiType.JS);
    }

    @Override
    @Nullable
    public String getVersion() {
        String fileName = this.getSrcFile().getName();
        int firstDash = fileName.indexOf("-");
        if (firstDash > 0) {
            return fileName.substring(firstDash + 1, fileName.lastIndexOf(".js"));
        }
        return "";
    }

    @Override
    public void start(PluginGuiceEnvironment env) throws Exception {
        this.manager = new LifecycleManager();
        String fileName = this.getSrcFile().getName();
        this.httpInjector = Guice.createInjector(new StandaloneJsPluginModule(this.getName(), fileName));
        this.manager.start();
    }

    @Override
    void stop(PluginGuiceEnvironment env) {
        if (this.manager != null) {
            this.manager.stop();
            this.httpInjector = null;
        }
    }

    @Override
    public Injector getSysInjector() {
        return null;
    }

    @Override
    @Nullable
    public Injector getSshInjector() {
        return null;
    }

    @Override
    @Nullable
    public Injector getHttpInjector() {
        return this.httpInjector;
    }

    @Override
    boolean canReload() {
        return true;
    }

    @Override
    public PluginContentScanner getContentScanner() {
        return PluginContentScanner.EMPTY;
    }

    private static final class StandaloneJsPluginModule
    extends AbstractModule {
        private final String fileName;
        private final String pluginName;

        StandaloneJsPluginModule(String pluginName, String fileName) {
            this.pluginName = pluginName;
            this.fileName = fileName;
        }

        @Override
        protected void configure() {
            this.bind(String.class).annotatedWith(PluginName.class).toInstance(this.pluginName);
            DynamicSet.bind(this.binder(), WebUiPlugin.class).toInstance(new JavaScriptPlugin(this.fileName));
        }
    }
}

