/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class PluginEntry {
    public static final String ATTR_CHARACTER_ENCODING = "Character-Encoding";
    public static final String ATTR_CONTENT_TYPE = "Content-Type";
    public static final Comparator<PluginEntry> COMPARATOR_BY_NAME = new Comparator<PluginEntry>(){

        @Override
        public int compare(PluginEntry a, PluginEntry b) {
            return a.getName().compareTo(b.getName());
        }
    };
    private static final Map<Object, String> EMPTY_ATTRS = Collections.emptyMap();
    private static final Optional<Long> NO_SIZE = Optional.absent();
    private final String name;
    private final long time;
    private final Optional<Long> size;
    private final Map<Object, String> attrs;

    public PluginEntry(String name, long time, Optional<Long> size, Map<Object, String> attrs) {
        this.name = name;
        this.time = time;
        this.size = size;
        this.attrs = attrs;
    }

    public PluginEntry(String name, long time, Optional<Long> size) {
        this(name, time, size, EMPTY_ATTRS);
    }

    public PluginEntry(String name, long time) {
        this(name, time, NO_SIZE, EMPTY_ATTRS);
    }

    public String getName() {
        return this.name;
    }

    public long getTime() {
        return this.time;
    }

    public Optional<Long> getSize() {
        return this.size;
    }

    public Map<Object, String> getAttrs() {
        return this.attrs;
    }
}

