/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.common.data.ContributorAgreement;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.InternalUser;
import com.google.gerrit.server.change.IncludedInResolver;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.config.GitReceivePackGroups;
import com.google.gerrit.server.config.GitUploadPackGroups;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.PerRequestProjectControlCache;
import com.google.gerrit.server.project.PermissionCollection;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.project.SectionMatcher;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectControl {
    public static final int VISIBLE = 1;
    public static final int OWNER = 2;
    private static final Logger log = LoggerFactory.getLogger(ProjectControl.class);
    private final Set<AccountGroup.UUID> uploadGroups;
    private final Set<AccountGroup.UUID> receiveGroups;
    private final String canonicalWebUrl;
    private final CurrentUser user;
    private final ProjectState state;
    private final GitRepositoryManager repoManager;
    private final ChangeControl.AssistedFactory changeControlFactory;
    private final PermissionCollection.Factory permissionFilter;
    private final Collection<ContributorAgreement> contributorAgreements;
    private List<SectionMatcher> allSections;
    private List<SectionMatcher> localSections;
    private LabelTypes labelTypes;
    private Map<String, RefControl> refControls;
    private Boolean declaredOwner;

    @Inject
    ProjectControl(@GitUploadPackGroups Set<AccountGroup.UUID> uploadGroups, @GitReceivePackGroups Set<AccountGroup.UUID> receiveGroups, ProjectCache pc, PermissionCollection.Factory permissionFilter, GitRepositoryManager repoManager, ChangeControl.AssistedFactory changeControlFactory, @CanonicalWebUrl @Nullable String canonicalWebUrl, @Assisted CurrentUser who, @Assisted ProjectState ps) {
        this.repoManager = repoManager;
        this.changeControlFactory = changeControlFactory;
        this.uploadGroups = uploadGroups;
        this.receiveGroups = receiveGroups;
        this.permissionFilter = permissionFilter;
        this.contributorAgreements = pc.getAllProjects().getConfig().getContributorAgreements();
        this.canonicalWebUrl = canonicalWebUrl;
        this.user = who;
        this.state = ps;
    }

    public ProjectControl forUser(CurrentUser who) {
        ProjectControl r = this.state.controlFor(who);
        r.allSections = this.allSections;
        return r;
    }

    public ChangeControl controlFor(Change change) {
        return this.changeControlFactory.create(this.controlForRef(change.getDest()), change);
    }

    public RefControl controlForRef(Branch.NameKey ref) {
        return this.controlForRef(ref.get());
    }

    public RefControl controlForRef(String refName) {
        RefControl ctl;
        if (this.refControls == null) {
            this.refControls = new HashMap<String, RefControl>();
        }
        if ((ctl = this.refControls.get(refName)) == null) {
            ImmutableList.Builder usernames = ImmutableList.builder();
            if (this.user.getUserName() != null) {
                usernames.add(this.user.getUserName());
            }
            if (this.user instanceof IdentifiedUser) {
                usernames.addAll(((IdentifiedUser)this.user).getEmailAddresses());
            }
            PermissionCollection relevant = this.permissionFilter.filter(this.access(), refName, usernames.build());
            ctl = new RefControl(this, refName, relevant);
            this.refControls.put(refName, ctl);
        }
        return ctl;
    }

    public CurrentUser getCurrentUser() {
        return this.user;
    }

    public ProjectState getProjectState() {
        return this.state;
    }

    public Project getProject() {
        return this.state.getProject();
    }

    public LabelTypes getLabelTypes() {
        if (this.labelTypes == null) {
            this.labelTypes = this.state.getLabelTypes();
        }
        return this.labelTypes;
    }

    private boolean isHidden() {
        return this.getProject().getState().equals((Object)com.google.gerrit.extensions.api.projects.ProjectState.HIDDEN);
    }

    public boolean isVisible() {
        return (this.user instanceof InternalUser || this.canPerformOnAnyRef("read")) && !this.isHidden();
    }

    public boolean canAddRefs() {
        return this.canPerformOnAnyRef("create") || this.isOwnerAnyRef();
    }

    public boolean canUpload() {
        for (SectionMatcher matcher : this.access()) {
            Permission permission;
            AccessSection section = matcher.section;
            if (!section.getName().startsWith("refs/for/") || (permission = section.getPermission("push")) == null || !this.controlForRef(section.getName()).canPerform("push")) continue;
            return true;
        }
        return false;
    }

    public boolean allRefsAreVisible() {
        return this.allRefsAreVisibleExcept(Collections.emptySet());
    }

    public boolean allRefsAreVisibleExcept(Set<String> except) {
        return this.user instanceof InternalUser || this.canPerformOnAllRefs("read", except);
    }

    public boolean isOwner() {
        return this.isDeclaredOwner() || this.user.getCapabilities().canAdministrateServer();
    }

    private boolean isDeclaredOwner() {
        if (this.declaredOwner == null) {
            this.declaredOwner = this.state.isOwner(this.user.getEffectiveGroups());
        }
        return this.declaredOwner;
    }

    public boolean isOwnerAnyRef() {
        return this.canPerformOnAnyRef("owner") || this.user.getCapabilities().canAdministrateServer();
    }

    public Capable canPushToAtLeastOneRef() {
        if (!this.canPerformOnAnyRef("push") && !this.canPerformOnAnyRef("pushTag")) {
            String pName = this.state.getProject().getName();
            return new Capable("Upload denied for project '" + pName + "'");
        }
        if (this.state.isUseContributorAgreements()) {
            return this.verifyActiveContributorAgreement();
        }
        return Capable.OK;
    }

    public Set<GroupReference> getAllGroups() {
        return ProjectControl.getGroups(this.access());
    }

    public Set<GroupReference> getLocalGroups() {
        return ProjectControl.getGroups(this.localAccess());
    }

    private static Set<GroupReference> getGroups(List<SectionMatcher> sectionMatcherList) {
        HashSet<GroupReference> all = new HashSet<GroupReference>();
        for (SectionMatcher matcher : sectionMatcherList) {
            AccessSection section = matcher.section;
            for (Permission permission : section.getPermissions()) {
                for (PermissionRule rule : permission.getRules()) {
                    all.add(rule.getGroup());
                }
            }
        }
        return all;
    }

    private Capable verifyActiveContributorAgreement() {
        StringBuilder msg;
        if (!this.user.isIdentifiedUser()) {
            return new Capable("Must be logged in to verify Contributor Agreement");
        }
        IdentifiedUser iUser = (IdentifiedUser)this.user;
        boolean hasContactInfo = !ProjectControl.missing(iUser.getAccount().getFullName()) && !ProjectControl.missing(iUser.getAccount().getPreferredEmail()) && iUser.getAccount().isContactFiled();
        ArrayList<AccountGroup.UUID> okGroupIds = Lists.newArrayList();
        ArrayList<AccountGroup.UUID> missingInfoGroupIds = Lists.newArrayList();
        for (ContributorAgreement ca : this.contributorAgreements) {
            ArrayList<AccountGroup.UUID> groupIds = hasContactInfo || !ca.isRequireContactInformation() ? okGroupIds : missingInfoGroupIds;
            for (PermissionRule rule : ca.getAccepted()) {
                if (rule.getAction() != PermissionRule.Action.ALLOW || rule.getGroup() == null || rule.getGroup().getUUID() == null) continue;
                groupIds.add(new AccountGroup.UUID(rule.getGroup().getUUID().get()));
            }
        }
        if (iUser.getEffectiveGroups().containsAnyOf(okGroupIds)) {
            return Capable.OK;
        }
        if (iUser.getEffectiveGroups().containsAnyOf(missingInfoGroupIds)) {
            msg = new StringBuilder();
            for (ContributorAgreement ca : this.contributorAgreements) {
                if (!ca.isRequireContactInformation()) continue;
                msg.append(ca.getName());
                break;
            }
            msg.append(" contributor agreement requires");
            msg.append(" current contact information.\n");
            if (this.canonicalWebUrl != null) {
                msg.append("\nPlease review your contact information");
                msg.append(":\n\n  ");
                msg.append(this.canonicalWebUrl);
                msg.append("#");
                msg.append("/settings/contact");
                msg.append("\n");
            }
            msg.append("\n");
            return new Capable(msg.toString());
        }
        msg = new StringBuilder();
        msg.append(" A Contributor Agreement must be completed before uploading");
        if (this.canonicalWebUrl != null) {
            msg.append(":\n\n  ");
            msg.append(this.canonicalWebUrl);
            msg.append("#");
            msg.append("/settings/agreements");
            msg.append("\n");
        } else {
            msg.append(".");
        }
        msg.append("\n");
        return new Capable(msg.toString());
    }

    private static boolean missing(String value) {
        return value == null || value.trim().equals("");
    }

    private boolean canPerformOnAnyRef(String permissionName) {
        block0: for (SectionMatcher matcher : this.access()) {
            AccessSection section = matcher.section;
            Permission permission = section.getPermission(permissionName);
            if (permission == null) continue;
            for (PermissionRule rule : permission.getRules()) {
                if (rule.isBlock() || rule.isDeny() || !this.match(rule)) continue;
                if (!this.controlForRef(section.getName()).canPerform(permissionName)) continue block0;
                return true;
            }
        }
        return false;
    }

    private boolean canPerformOnAllRefs(String permission, Set<String> except) {
        boolean canPerform = false;
        Set<String> patterns = this.allRefPatterns(permission);
        if (patterns.contains("refs/*")) {
            for (String pattern : patterns) {
                if (this.controlForRef(pattern).canPerform(permission)) {
                    canPerform = true;
                    continue;
                }
                if (except.contains(pattern)) continue;
                return false;
            }
        }
        return canPerform;
    }

    private Set<String> allRefPatterns(String permissionName) {
        HashSet<String> all = new HashSet<String>();
        for (SectionMatcher matcher : this.access()) {
            AccessSection section = matcher.section;
            Permission permission = section.getPermission(permissionName);
            if (permission == null) continue;
            all.add(section.getName());
        }
        return all;
    }

    private List<SectionMatcher> access() {
        if (this.allSections == null) {
            this.allSections = this.state.getAllSections();
        }
        return this.allSections;
    }

    private List<SectionMatcher> localAccess() {
        if (this.localSections == null) {
            this.localSections = this.state.getLocalAccessSections();
        }
        return this.localSections;
    }

    boolean match(PermissionRule rule) {
        return this.match(rule.getGroup().getUUID());
    }

    boolean match(PermissionRule rule, boolean isChangeOwner) {
        return this.match(rule.getGroup().getUUID(), isChangeOwner);
    }

    boolean match(AccountGroup.UUID uuid) {
        return this.match(uuid, false);
    }

    boolean match(AccountGroup.UUID uuid, boolean isChangeOwner) {
        if (SystemGroupBackend.PROJECT_OWNERS.equals(uuid)) {
            return this.isDeclaredOwner();
        }
        if (SystemGroupBackend.CHANGE_OWNER.equals(uuid)) {
            return isChangeOwner;
        }
        return this.user.getEffectiveGroups().contains(uuid);
    }

    public boolean canRunUploadPack() {
        for (AccountGroup.UUID group : this.uploadGroups) {
            if (!this.match(group)) continue;
            return true;
        }
        return false;
    }

    public boolean canRunReceivePack() {
        for (AccountGroup.UUID group : this.receiveGroups) {
            if (!this.match(group)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canReadCommit(RevWalk rw, RevCommit commit) {
        if (this.controlForRef("refs/*").canPerform("read")) {
            return true;
        }
        Project.NameKey projName = this.state.getProject().getNameKey();
        try (Repository repo = this.repoManager.openRepository(projName);){
            RefDatabase refDb = repo.getRefDatabase();
            LinkedList<Ref> allRefs = Lists.newLinkedList();
            allRefs.addAll(refDb.getRefs("refs/heads/").values());
            allRefs.addAll(refDb.getRefs("refs/tags/").values());
            LinkedList<Ref> canReadRefs = Lists.newLinkedList();
            for (Ref r : allRefs) {
                if (!this.controlForRef(r.getName()).canPerform("read")) continue;
                canReadRefs.add(r);
            }
            if (canReadRefs.isEmpty()) return false;
            if (!IncludedInResolver.includedInOne(repo, rw, commit, canReadRefs)) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            String msg = String.format("Cannot verify permissions to commit object %s in repository %s", commit.name(), projName.get());
            log.error(msg, e);
        }
        return false;
    }

    public static interface AssistedFactory {
        public ProjectControl create(CurrentUser var1, ProjectState var2);
    }

    public static class Factory {
        private final Provider<PerRequestProjectControlCache> userCache;

        @Inject
        Factory(Provider<PerRequestProjectControlCache> uc) {
            this.userCache = uc;
        }

        public ProjectControl controlFor(Project.NameKey nameKey) throws NoSuchProjectException {
            return this.userCache.get().get(nameKey);
        }

        public ProjectControl validateFor(Project.NameKey nameKey) throws NoSuchProjectException {
            return this.validateFor(nameKey, 1);
        }

        public ProjectControl ownerFor(Project.NameKey nameKey) throws NoSuchProjectException {
            return this.validateFor(nameKey, 2);
        }

        public ProjectControl validateFor(Project.NameKey nameKey, int need) throws NoSuchProjectException {
            ProjectControl c = this.controlFor(nameKey);
            if ((need & 1) == 1 && c.isVisible()) {
                return c;
            }
            if ((need & 2) == 2 && c.isOwner()) {
                return c;
            }
            throw new NoSuchProjectException(nameKey);
        }
    }

    public static class GenericFactory {
        private final ProjectCache projectCache;

        @Inject
        GenericFactory(ProjectCache pc) {
            this.projectCache = pc;
        }

        public ProjectControl controlFor(Project.NameKey nameKey, CurrentUser user) throws NoSuchProjectException, IOException {
            ProjectState p = this.projectCache.checkedGet(nameKey);
            if (p == null) {
                throw new NoSuchProjectException(nameKey);
            }
            return p.controlFor(user);
        }

        public ProjectControl validateFor(Project.NameKey nameKey, int need, CurrentUser user) throws NoSuchProjectException, IOException {
            ProjectControl c = this.controlFor(nameKey, user);
            if ((need & 1) == 1 && c.isVisible()) {
                return c;
            }
            if ((need & 2) == 2 && c.isOwner()) {
                return c;
            }
            throw new NoSuchProjectException(nameKey);
        }
    }
}

