/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.common.ListChangesOption;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.QueryProcessor;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.args4j.Option;

public class QueryChanges
implements RestReadView<TopLevelResource> {
    private final ChangeJson json;
    private final QueryProcessor imp;
    private final Provider<CurrentUser> user;
    private boolean reverse;
    private EnumSet<ListChangesOption> options;
    @Option(name="--query", aliases={"-q"}, metaVar="QUERY", usage="Query string")
    private List<String> queries;

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="Maximum number of results to return")
    public void setLimit(int limit) {
        this.imp.setLimit(limit);
    }

    @Option(name="-o", usage="Output options per change")
    public void addOption(ListChangesOption o) {
        this.options.add(o);
    }

    @Option(name="-O", usage="Output option flags, in hex")
    void setOptionFlagsHex(String hex) {
        this.options.addAll(ListChangesOption.fromBits(Integer.parseInt(hex, 16)));
    }

    @Option(name="-P", metaVar="SORTKEY", usage="Previous changes before SORTKEY")
    public void setSortKeyAfter(String key) {
        this.imp.setSortkeyAfter(key);
        this.reverse = true;
    }

    @Option(name="-N", metaVar="SORTKEY", usage="Next changes after SORTKEY")
    public void setSortKeyBefore(String key) {
        this.imp.setSortkeyBefore(key);
    }

    @Option(name="--start", aliases={"-S"}, metaVar="CNT", usage="Number of changes to skip")
    public void setStart(int start) {
        this.imp.setStart(start);
    }

    @Inject
    QueryChanges(ChangeJson json, QueryProcessor qp, Provider<CurrentUser> user) {
        this.json = json;
        this.imp = qp;
        this.user = user;
        this.options = EnumSet.noneOf(ListChangesOption.class);
    }

    public void addQuery(String query) {
        if (this.queries == null) {
            this.queries = Lists.newArrayList();
        }
        this.queries.add(query);
    }

    public String getQuery(int i) {
        return this.queries.get(i);
    }

    public List<?> apply(TopLevelResource rsrc) throws BadRequestException, AuthException, OrmException {
        List<List<ChangeJson.ChangeInfo>> out;
        try {
            out = this.query();
        }
        catch (QueryParseException e) {
            Pattern p = Pattern.compile("^Error in operator (.*:self)$");
            Matcher m = p.matcher(e.getMessage());
            if (m.matches()) {
                String op = m.group(1);
                throw new AuthException("Must be signed-in to use " + op);
            }
            throw new BadRequestException(e.getMessage());
        }
        return out.size() == 1 ? out.get(0) : out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<ChangeJson.ChangeInfo>> query() throws OrmException, QueryParseException {
        if (this.imp.isDisabled()) {
            throw new QueryParseException("query disabled");
        }
        if (this.queries == null || this.queries.isEmpty()) {
            this.queries = Collections.singletonList("status:open");
        } else if (this.queries.size() > 10) {
            throw new QueryParseException("limit of 10 queries");
        }
        IdentifiedUser self = null;
        try {
            if (this.user.get().isIdentifiedUser()) {
                self = (IdentifiedUser)this.user.get();
                self.asyncStarredChanges();
            }
            List<List<ChangeJson.ChangeInfo>> list = this.query0();
            return list;
        }
        finally {
            if (self != null) {
                self.abortStarredChanges();
            }
        }
    }

    private List<List<ChangeJson.ChangeInfo>> query0() throws OrmException, QueryParseException {
        int cnt = this.queries.size();
        BitSet more = new BitSet(cnt);
        List<List<ChangeData>> data = this.imp.queryChanges(this.queries);
        for (int n = 0; n < cnt; ++n) {
            List<ChangeData> changes = data.get(n);
            if (this.imp.getLimit() <= 0 || changes.size() <= this.imp.getLimit()) continue;
            changes = this.reverse ? changes.subList(1, changes.size()) : changes.subList(0, this.imp.getLimit());
            data.set(n, changes);
            more.set(n, true);
        }
        List<List<ChangeJson.ChangeInfo>> res = this.json.addOptions(this.options).formatList2(data);
        for (int n = 0; n < cnt; ++n) {
            List<ChangeJson.ChangeInfo> info = res.get(n);
            if (!more.get(n) || info.isEmpty()) continue;
            if (this.reverse) {
                info.get((int)0)._moreChanges = true;
                continue;
            }
            info.get((int)(info.size() - 1))._moreChanges = true;
        }
        return res;
    }
}

