/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.RegexPredicate;
import com.google.gerrit.server.index.Schema;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.TopicPredicate;
import com.google.gwtorm.server.OrmException;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;

class RegexTopicPredicate
extends RegexPredicate<ChangeData> {
    private final RunAutomaton pattern;

    RegexTopicPredicate(Schema<ChangeData> schema, String re) {
        super(TopicPredicate.topicField(schema), re);
        if (re.startsWith("^")) {
            re = re.substring(1);
        }
        if (re.endsWith("$") && !re.endsWith("\\$")) {
            re = re.substring(0, re.length() - 1);
        }
        this.pattern = new RunAutomaton(new RegExp(re).toAutomaton());
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change change = object.change();
        if (change == null || change.getTopic() == null) {
            return false;
        }
        return this.pattern.run(change.getTopic());
    }

    @Override
    public int getCost() {
        return 1;
    }
}

