/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.common.errors.NameAlreadyUsedException;
import com.google.gerrit.common.errors.PermissionDeniedException;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.CreateGroupArgs;
import com.google.gerrit.server.account.PerformCreateGroup;
import com.google.gerrit.server.validators.GroupCreationValidationListener;
import com.google.gerrit.server.validators.ValidationException;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="createGroup")
@CommandMetaData(name="create-group", description="Create a new account group")
final class CreateGroupCommand
extends SshCommand {
    @Option(name="--owner", aliases={"-o"}, metaVar="GROUP", usage="owning group, if not specified the group will be self-owning")
    private AccountGroup.Id ownerGroupId;
    @Option(name="--description", aliases={"-d"}, metaVar="DESC", usage="description of group")
    private String groupDescription = "";
    @Argument(index=0, required=true, metaVar="GROUP", usage="name of group to be created")
    private String groupName;
    private final Set<Account.Id> initialMembers = new HashSet<Account.Id>();
    @Option(name="--visible-to-all", usage="to make the group visible to all registered users")
    private boolean visibleToAll;
    private final Set<AccountGroup.UUID> initialGroups = new HashSet<AccountGroup.UUID>();
    @Inject
    private PerformCreateGroup.Factory performCreateGroupFactory;
    @Inject
    private DynamicSet<GroupCreationValidationListener> groupCreationValidationListeners;

    CreateGroupCommand() {
    }

    @Option(name="--member", aliases={"-m"}, metaVar="USERNAME", usage="initial set of users to become members of the group")
    void addMember(Account.Id id) {
        this.initialMembers.add(id);
    }

    @Option(name="--group", aliases={"-g"}, metaVar="GROUP", usage="initial set of groups to be included in the group")
    void addGroup(AccountGroup.UUID id) {
        this.initialGroups.add(id);
    }

    @Override
    protected void run() throws BaseCommand.Failure, OrmException {
        try {
            CreateGroupArgs args = new CreateGroupArgs();
            args.setGroupName(this.groupName);
            args.groupDescription = this.groupDescription;
            args.visibleToAll = this.visibleToAll;
            args.ownerGroupId = this.ownerGroupId;
            args.initialMembers = this.initialMembers;
            args.initialGroups = this.initialGroups;
            for (GroupCreationValidationListener l : this.groupCreationValidationListeners) {
                try {
                    l.validateNewGroup(args);
                }
                catch (ValidationException e) {
                    this.die(e);
                }
            }
            this.performCreateGroupFactory.create(args).createGroup();
        }
        catch (PermissionDeniedException e) {
            throw this.die(e);
        }
        catch (NameAlreadyUsedException e) {
            throw this.die(e);
        }
    }
}

