/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.Trail;
import com.googlecode.prolog_cafe.lang.VariableTerm;
import java.util.ArrayList;
import java.util.List;

public class ListTerm
extends Term {
    protected static final SymbolTerm SYM_DOT = SymbolTerm.intern(".", 2);
    protected Term car;
    protected Term cdr;

    public ListTerm(Term term, Term term2) {
        this.car = term;
        this.cdr = term2;
    }

    public Term car() {
        return this.car;
    }

    public Term cdr() {
        return this.cdr;
    }

    public void setCar(Term term) {
        this.car = term;
    }

    public void setCdr(Term term) {
        this.cdr = term;
    }

    @Override
    public boolean unify(Term term, Trail trail) {
        if ((term = term.dereference()).isVariable()) {
            ((VariableTerm)term).bind(this, trail);
            return true;
        }
        if (!term.isList()) {
            return false;
        }
        return this.car.unify(((ListTerm)term).car(), trail) && this.cdr.unify(((ListTerm)term).cdr(), trail);
    }

    @Override
    public boolean convertible(Class clazz) {
        return ListTerm.convertible(List.class, clazz);
    }

    @Override
    protected Term copy(Prolog prolog) {
        return new ListTerm(this.car.copy(prolog), this.cdr.copy(prolog));
    }

    @Override
    public boolean isGround() {
        if (!this.car.isGround()) {
            return false;
        }
        return this.cdr.isGround();
    }

    @Override
    public String name() {
        return SYM_DOT.name();
    }

    @Override
    public Term arg(int n) {
        Term term = this;
        int n2 = n;
        while (term.isList() && 0 < n) {
            --n;
            term = term.cdr.dereference();
        }
        if (term.isList()) {
            return term.car;
        }
        throw new ArrayIndexOutOfBoundsException(n2);
    }

    public int length() {
        int n = 0;
        Term term = this;
        while (term.isList()) {
            ++n;
            term = term.cdr().dereference();
        }
        return n;
    }

    @Override
    public List toJava() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Term term = this;
        while (term.isList()) {
            arrayList.add(term.car().dereference().toJava());
            term = term.cdr().dereference();
        }
        return arrayList;
    }

    @Override
    public String toQuotedString() {
        Term term = this;
        String string = "[";
        while (true) {
            string = string + ((ListTerm)term).car.dereference().toQuotedString();
            term = ((ListTerm)term).cdr.dereference();
            if (!term.isList()) break;
            string = string + ",";
        }
        if (!term.isNil()) {
            string = string + "|" + term.toQuotedString();
        }
        string = string + "]";
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ListTerm)) {
            return false;
        }
        return this.car.equals(((ListTerm)object).car().dereference()) && this.cdr.equals(((ListTerm)object).cdr().dereference());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + SYM_DOT.hashCode();
        n = 31 * n + this.car.dereference().hashCode();
        n = 31 * n + this.cdr.dereference().hashCode();
        return n;
    }

    public String toString() {
        Term term = this;
        String string = "[";
        while (true) {
            string = string + ((ListTerm)term).car.dereference().toString();
            term = ((ListTerm)term).cdr.dereference();
            if (!term.isList()) break;
            string = string + ",";
        }
        if (!term.isNil()) {
            string = string + "|" + term.toString();
        }
        string = string + "]";
        return string;
    }

    @Override
    public int compareTo(Term term) {
        Term term2;
        if (term.isVariable() || term.isNumber() || term.isSymbol()) {
            return 1;
        }
        if (term.isStructure()) {
            int n = ((StructureTerm)term).arity();
            if (2 != n) {
                return 2 - n;
            }
            term2 = ((StructureTerm)term).functor();
            if (!SYM_DOT.equals(term2)) {
                return SYM_DOT.compareTo(term2);
            }
        }
        Term[] termArray = new Term[2];
        if (term.isList()) {
            termArray[0] = ((ListTerm)term).car();
            termArray[1] = ((ListTerm)term).cdr();
        } else if (term.isStructure()) {
            termArray = ((StructureTerm)term).args();
        } else {
            return -1;
        }
        term2 = this.car;
        for (int i = 0; i < 2; ++i) {
            int n = term2.compareTo(termArray[i].dereference());
            if (n != 0) {
                return n;
            }
            term2 = this.cdr;
        }
        return 0;
    }
}

