/*
 * Decompiled with CFR 0.152.
 */
package gerrit;

import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.rules.StoredValues;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListEntry;
import com.googlecode.prolog_cafe.lang.IllegalTypeException;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.PInstantiationException;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.PrologException;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import java.util.Iterator;
import java.util.regex.Pattern;

public class PRED_commit_delta_4
extends Predicate.P4 {
    private static final SymbolTerm add = SymbolTerm.intern("add");
    private static final SymbolTerm modify = SymbolTerm.intern("modify");
    private static final SymbolTerm delete = SymbolTerm.intern("delete");
    private static final SymbolTerm rename = SymbolTerm.intern("rename");
    private static final SymbolTerm copy = SymbolTerm.intern("copy");
    static final Operation commit_delta_check = new PRED_commit_delta_check();
    static final Operation commit_delta_next = new PRED_commit_delta_next();
    static final Operation commit_delta_empty = new PRED_commit_delta_empty();

    public PRED_commit_delta_4(Term a1, Term a2, Term a3, Term a4, Operation n) {
        this.arg1 = a1;
        this.arg2 = a2;
        this.arg3 = a3;
        this.arg4 = a4;
        this.cont = n;
    }

    @Override
    public Operation exec(Prolog engine) throws PrologException {
        engine.cont = this.cont;
        engine.setB0();
        Term a1 = this.arg1.dereference();
        if (a1.isVariable()) {
            throw new PInstantiationException(this, 1);
        }
        if (!a1.isSymbol()) {
            throw new IllegalTypeException(this, 1, "symbol", a1);
        }
        Pattern regex = Pattern.compile(a1.name());
        engine.areg1 = new JavaObjectTerm(regex);
        engine.areg2 = this.arg2;
        engine.areg3 = this.arg3;
        engine.areg4 = this.arg4;
        PatchList pl = StoredValues.PATCH_LIST.get(engine);
        Iterator<PatchListEntry> iter = pl.getPatches().iterator();
        engine.areg5 = new JavaObjectTerm(iter);
        return engine.jtry5(commit_delta_check, commit_delta_next);
    }

    private static SymbolTerm getTypeSymbol(Patch.ChangeType type) {
        switch (type) {
            case ADDED: {
                return add;
            }
            case MODIFIED: {
                return modify;
            }
            case DELETED: {
                return delete;
            }
            case RENAMED: {
                return rename;
            }
            case COPIED: {
                return copy;
            }
        }
        throw new IllegalArgumentException("ChangeType not recognized");
    }

    private static final class PRED_commit_delta_empty
    extends Operation {
        private PRED_commit_delta_empty() {
        }

        @Override
        public Operation exec(Prolog engine) {
            Term a5 = engine.areg5;
            Iterator iter = (Iterator)((JavaObjectTerm)a5).object();
            if (!iter.hasNext()) {
                return engine.fail();
            }
            return engine.jtry5(commit_delta_check, commit_delta_next);
        }
    }

    private static final class PRED_commit_delta_next
    extends Operation {
        private PRED_commit_delta_next() {
        }

        @Override
        public Operation exec(Prolog engine) {
            return engine.trust(commit_delta_empty);
        }
    }

    private static final class PRED_commit_delta_check
    extends Operation {
        private PRED_commit_delta_check() {
        }

        @Override
        public Operation exec(Prolog engine) {
            Term a1 = engine.areg1;
            Term a2 = engine.areg2;
            Term a3 = engine.areg3;
            Term a4 = engine.areg4;
            Term a5 = engine.areg5;
            Pattern regex = (Pattern)((JavaObjectTerm)a1).object();
            Iterator iter = (Iterator)((JavaObjectTerm)a5).object();
            while (iter.hasNext()) {
                PatchListEntry patch = (PatchListEntry)iter.next();
                String newName = patch.getNewName();
                String oldName = patch.getOldName();
                Patch.ChangeType changeType = patch.getChangeType();
                if (newName.equals("/COMMIT_MSG") || !regex.matcher(newName).find() && (oldName == null || !regex.matcher(oldName).find())) continue;
                SymbolTerm changeSym = PRED_commit_delta_4.getTypeSymbol(changeType);
                SymbolTerm newSym = SymbolTerm.create(newName);
                SymbolTerm oldSym = Prolog.Nil;
                if (oldName != null) {
                    oldSym = SymbolTerm.create(oldName);
                }
                if (!a2.unify(changeSym, engine.trail) || !a3.unify(newSym, engine.trail) || !a4.unify(oldSym, engine.trail)) continue;
                return engine.cont;
            }
            return engine.fail();
        }
    }
}

