/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.archive;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.archive.TarFormat;
import org.eclipse.jgit.archive.Tbz2Format;
import org.eclipse.jgit.archive.TgzFormat;
import org.eclipse.jgit.archive.TxzFormat;
import org.eclipse.jgit.archive.ZipFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveFormats {
    private static final List<String> myFormats = new ArrayList<String>();

    private static final void register(String name, ArchiveCommand.Format<?> fmt) {
        myFormats.add(name);
        ArchiveCommand.registerFormat(name, fmt);
    }

    public static void registerAll() {
        ArchiveFormats.register("tar", new TarFormat());
        ArchiveFormats.register("tgz", new TgzFormat());
        ArchiveFormats.register("tbz2", new Tbz2Format());
        ArchiveFormats.register("txz", new TxzFormat());
        ArchiveFormats.register("zip", new ZipFormat());
    }

    public static void unregisterAll() {
        for (String name : myFormats) {
            ArchiveCommand.unregisterFormat(name);
        }
        myFormats.clear();
    }
}

