/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.GitwebConfig;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGeneralPreferences;
import com.google.gerrit.reviewdb.client.AuthType;
import com.google.gerrit.reviewdb.client.Project;
import java.util.List;
import java.util.Set;

public class GerritConfig
implements Cloneable {
    protected String registerUrl;
    protected String registerText;
    protected String loginUrl;
    protected String loginText;
    protected String switchAccountUrl;
    protected String httpPasswordUrl;
    protected String reportBugUrl;
    protected String reportBugText;
    protected boolean httpPasswordSettingsEnabled = true;
    protected GitwebConfig gitweb;
    protected boolean useContributorAgreements;
    protected boolean useContactInfo;
    protected boolean allowRegisterNewEmail;
    protected AuthType authType;
    protected Set<AccountGeneralPreferences.DownloadScheme> downloadSchemes;
    protected Set<AccountGeneralPreferences.DownloadCommand> downloadCommands;
    protected String gitDaemonUrl;
    protected String gitHttpUrl;
    protected String sshdAddress;
    protected String editFullNameUrl;
    protected Project.NameKey wildProject;
    protected Set<Account.FieldName> editableAccountFields;
    protected boolean documentationAvailable;
    protected String anonymousCowardName;
    protected int suggestFrom;
    protected int changeUpdateDelay;
    protected AccountGeneralPreferences.ChangeScreen changeScreen;
    protected List<String> archiveFormats;
    protected int largeChangeSize;
    protected boolean newFeatures;

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String u) {
        this.loginUrl = u;
    }

    public String getLoginText() {
        return this.loginText;
    }

    public void setLoginText(String signinText) {
        this.loginText = signinText;
    }

    public String getRegisterUrl() {
        return this.registerUrl;
    }

    public void setRegisterUrl(String u) {
        this.registerUrl = u;
    }

    public String getSwitchAccountUrl() {
        return this.switchAccountUrl;
    }

    public void setSwitchAccountUrl(String u) {
        this.switchAccountUrl = u;
    }

    public String getRegisterText() {
        return this.registerText;
    }

    public void setRegisterText(String t) {
        this.registerText = t;
    }

    public String getReportBugUrl() {
        return this.reportBugUrl;
    }

    public void setReportBugUrl(String u) {
        this.reportBugUrl = u;
    }

    public String getReportBugText() {
        return this.reportBugText;
    }

    public void setReportBugText(String t) {
        this.reportBugText = t;
    }

    public boolean isHttpPasswordSettingsEnabled() {
        return this.httpPasswordSettingsEnabled;
    }

    public void setHttpPasswordSettingsEnabled(boolean httpPasswordSettingsEnabled) {
        this.httpPasswordSettingsEnabled = httpPasswordSettingsEnabled;
    }

    public String getEditFullNameUrl() {
        return this.editFullNameUrl;
    }

    public void setEditFullNameUrl(String u) {
        this.editFullNameUrl = u;
    }

    public String getHttpPasswordUrl() {
        return this.httpPasswordUrl;
    }

    public void setHttpPasswordUrl(String url) {
        this.httpPasswordUrl = url;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthType t) {
        this.authType = t;
    }

    public Set<AccountGeneralPreferences.DownloadScheme> getDownloadSchemes() {
        return this.downloadSchemes;
    }

    public void setDownloadSchemes(Set<AccountGeneralPreferences.DownloadScheme> s) {
        this.downloadSchemes = s;
    }

    public Set<AccountGeneralPreferences.DownloadCommand> getDownloadCommands() {
        return this.downloadCommands;
    }

    public void setDownloadCommands(Set<AccountGeneralPreferences.DownloadCommand> downloadCommands) {
        this.downloadCommands = downloadCommands;
    }

    public GitwebConfig getGitwebLink() {
        return this.gitweb;
    }

    public void setGitwebLink(GitwebConfig w) {
        this.gitweb = w;
    }

    public boolean isUseContributorAgreements() {
        return this.useContributorAgreements;
    }

    public void setUseContributorAgreements(boolean r) {
        this.useContributorAgreements = r;
    }

    public boolean isUseContactInfo() {
        return this.useContactInfo;
    }

    public void setUseContactInfo(boolean r) {
        this.useContactInfo = r;
    }

    public String getGitDaemonUrl() {
        return this.gitDaemonUrl;
    }

    public void setGitDaemonUrl(String url) {
        if (url != null && !url.endsWith("/")) {
            url = url + "/";
        }
        this.gitDaemonUrl = url;
    }

    public String getGitHttpUrl() {
        return this.gitHttpUrl;
    }

    public void setGitHttpUrl(String url) {
        if (url != null && !url.endsWith("/")) {
            url = url + "/";
        }
        this.gitHttpUrl = url;
    }

    public String getSshdAddress() {
        return this.sshdAddress;
    }

    public void setSshdAddress(String addr) {
        this.sshdAddress = addr;
    }

    public Project.NameKey getWildProject() {
        return this.wildProject;
    }

    public void setWildProject(Project.NameKey wp) {
        this.wildProject = wp;
    }

    public boolean canEdit(Account.FieldName f) {
        return this.editableAccountFields.contains((Object)f);
    }

    public Set<Account.FieldName> getEditableAccountFields() {
        return this.editableAccountFields;
    }

    public void setEditableAccountFields(Set<Account.FieldName> af) {
        this.editableAccountFields = af;
    }

    public boolean isDocumentationAvailable() {
        return this.documentationAvailable;
    }

    public void setDocumentationAvailable(boolean available) {
        this.documentationAvailable = available;
    }

    public String getAnonymousCowardName() {
        return this.anonymousCowardName;
    }

    public void setAnonymousCowardName(String anonymousCowardName) {
        this.anonymousCowardName = anonymousCowardName;
    }

    public int getSuggestFrom() {
        return this.suggestFrom;
    }

    public void setSuggestFrom(int suggestFrom) {
        this.suggestFrom = suggestFrom;
    }

    public boolean siteHasUsernames() {
        return this.getAuthType() != AuthType.CUSTOM_EXTENSION || this.getHttpPasswordUrl() == null || this.canEdit(Account.FieldName.USER_NAME);
    }

    public int getChangeUpdateDelay() {
        return this.changeUpdateDelay;
    }

    public void setChangeUpdateDelay(int seconds) {
        this.changeUpdateDelay = seconds;
    }

    public AccountGeneralPreferences.ChangeScreen getChangeScreen() {
        return this.changeScreen;
    }

    public void setChangeScreen(AccountGeneralPreferences.ChangeScreen ui) {
        this.changeScreen = ui;
    }

    public int getLargeChangeSize() {
        return this.largeChangeSize;
    }

    public void setLargeChangeSize(int largeChangeSize) {
        this.largeChangeSize = largeChangeSize;
    }

    public List<String> getArchiveFormats() {
        return this.archiveFormats;
    }

    public void setArchiveFormats(List<String> formats) {
        this.archiveFormats = formats;
    }

    public boolean getNewFeatures() {
        return this.newFeatures;
    }

    public void setNewFeatures(boolean n) {
        this.newFeatures = n;
    }
}

